#
# Copyright (c) 2001 - 2015 The SCons Foundation
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
# KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
# WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

__revision__ = "src/engine/SCons/Tool/PharLapCommonTests.py rel_2.4.1:3453:73fefd3ea0b0 2015/11/09 03:25:05 bdbaddog"

import unittest
import os.path
import os
import sys

import TestUnit

import SCons.Errors
from SCons.Tool.PharLapCommon import *

class PharLapCommonTestCase(unittest.TestCase):
    def test_addPathIfNotExists(self):
        """Test the addPathIfNotExists() function"""
        env_dict = { 'FOO' : os.path.normpath('/foo/bar') + os.pathsep + \
                     os.path.normpath('/baz/blat'),
                     'BAR' : os.path.normpath('/foo/bar') + os.pathsep + \
                     os.path.normpath('/baz/blat'),
                     'BLAT' : [ os.path.normpath('/foo/bar'),
                                os.path.normpath('/baz/blat') ] }
        addPathIfNotExists(env_dict, 'FOO', os.path.normpath('/foo/bar'))
        addPathIfNotExists(env_dict, 'BAR', os.path.normpath('/bar/foo'))
        addPathIfNotExists(env_dict, 'BAZ', os.path.normpath('/foo/baz'))
        addPathIfNotExists(env_dict, 'BLAT', os.path.normpath('/baz/blat'))
        addPathIfNotExists(env_dict, 'BLAT', os.path.normpath('/baz/foo'))

        assert env_dict['FOO'] == os.path.normpath('/foo/bar') + os.pathsep + \
               os.path.normpath('/baz/blat'), env_dict['FOO']
        assert env_dict['BAR'] == os.path.normpath('/bar/foo') + os.pathsep + \
               os.path.normpath('/foo/bar') + os.pathsep + \
               os.path.normpath('/baz/blat'), env_dict['BAR']
        assert env_dict['BAZ'] == os.path.normpath('/foo/baz'), env_dict['BAZ']
        assert env_dict['BLAT'] == [ os.path.normpath('/baz/foo'),
                                     os.path.normpath('/foo/bar'),
                                     os.path.normpath('/baz/blat') ], env_dict['BLAT' ]

if __name__ == "__main__":
    suite = unittest.makeSuite(PharLapCommonTestCase, 'test_')
    TestUnit.run(suite)

# Local Variables:
# tab-width:4
# indent-tabs-mode:nil
# End:
# vim: set expandtab tabstop=4 shiftwidth=4:
