// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008-2008 - INRIA - Jean-Baptiste Silvy
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- TEST WITH GRAPHIC -->

// <-- Non-regression test for bug 1839 -->
//
// <-- GitLab URL -->
// https://gitlab.com/scilab/scilab/-/issues/1839
//
// <-- Short Description -->
// Export to gif or PPM may create instability or crashes in Scilab.

t=[0:0.3:2*%pi]'; z=sin(t)*cos(t');
[xx,yy,zz]=genfac3d(t,t,z);
plot3d([xx xx],[yy yy],list([zz zz+4],[4*ones(1,400) 5*ones(1,400)]))
e=gce();
f=e.data;
TL = tlist(["3d" "x" "y" "z" "color"],f.x,f.y,f.z,6*rand(f.z)); // random color matrix
h=gce(); //get handle on current entity (here the surface)
f=gcf();//get the handle of the parent figure   
f.color_map=hotcolormap(512);
c=[1:400,1:400];
TL.color = [c;c+1;c+2;c+3];
h.data = TL;

// try to export to GIF or PPM
xs2gif(f.figure_id, TMPDIR + "/test.gif");
xs2ppm(f.figure_id, TMPDIR + "/test.ppm");
