/* PreferenceAction.h */

/* Copyright (C) 2011-2024 Michael Lugmair (Lucio Carreras)
 *
 * This file is part of sayonara player
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PREFERENCEACTION_H
#define PREFERENCEACTION_H

#include "Utils/Pimpl.h"

#include <QAction>

class QPushButton;

namespace Gui
{
	/**
	 * @brief A PreferenceAction can be added to each widget supporting
	 * QActions. When triggering this action, the PreferenceDialog is
	 * openend with the appropriate entry chosen
	 * @ingroup Preferences
	 */
	class PreferenceAction :
		public QAction
	{
		Q_OBJECT
		PIMPL(PreferenceAction)

		public:
			PreferenceAction(const QString& displayName, const QString& identifier, QWidget* parent);
			virtual ~PreferenceAction();

			[[nodiscard]] virtual QString label() const;
			[[nodiscard]] virtual QString identifier() const = 0;

			[[nodiscard]] virtual QPushButton* createButton(QWidget* parent);

		protected:
			[[nodiscard]] virtual QString displayName() const = 0;
			void language_changed();
	};

	/**
	 * @brief The LibraryPreferenceAction class
	 * @ingroup Preferences
	 */
	class LibraryPreferenceAction :
		public PreferenceAction
	{
		Q_OBJECT
		public:
			explicit LibraryPreferenceAction(QWidget* parent);
			~LibraryPreferenceAction() override;

			[[nodiscard]]    QString displayName() const override;
			[[nodiscard]]    QString identifier() const override;
	};

	/**
	 * @brief The PlaylistPreferenceAction class
	 * @ingroup Preferences
	 */
	class PlaylistPreferenceAction :
		public PreferenceAction
	{
		Q_OBJECT
		public:
			explicit PlaylistPreferenceAction(QWidget* parent);
			~PlaylistPreferenceAction() override;

			[[nodiscard]]    QString displayName() const override;
			[[nodiscard]]    QString identifier() const override;
	};

	/**
	 * @brief The SearchPreferenceAction class
	 * @ingroup Preferences
	 */
	class SearchPreferenceAction :
		public PreferenceAction
	{
		Q_OBJECT
		public:
			explicit SearchPreferenceAction(QWidget* parent);
			~SearchPreferenceAction() override;

			[[nodiscard]]    QString displayName() const override;
			[[nodiscard]]    QString identifier() const override;
	};

	/**
	 * @brief The CoverPreferenceAction class
	 * @ingroup Preferences
	 */
	class CoverPreferenceAction :
		public PreferenceAction
	{
		Q_OBJECT
		public:
			explicit CoverPreferenceAction(QWidget* parent);
			~CoverPreferenceAction() override;

			[[nodiscard]]    QString displayName() const override;
			[[nodiscard]]    QString identifier() const override;
	};

	/**
	 * @brief The PlayerPreferencesAction class
	 * @ingroup Preferences
	 */
	class PlayerPreferencesAction :
		public PreferenceAction
	{
		Q_OBJECT
		public:
			explicit PlayerPreferencesAction(QWidget* parent);
			~PlayerPreferencesAction() override;

			[[nodiscard]]    QString displayName() const override;
			[[nodiscard]]    QString identifier() const override;
	};

	/**
	 * @brief The StreamRecorderPreferenceAction class
	 * @ingroup Preferences
	 */
	class StreamRecorderPreferenceAction :
		public PreferenceAction
	{
		Q_OBJECT
		public:
			explicit StreamRecorderPreferenceAction(QWidget* parent);
			~StreamRecorderPreferenceAction() override;

			[[nodiscard]] QString displayName() const override;
			[[nodiscard]] QString identifier() const override;
	};

	class ShortcutPreferenceAction :
		public Gui::PreferenceAction
	{
		Q_OBJECT

		public:
			explicit ShortcutPreferenceAction(QWidget* parent);
			~ShortcutPreferenceAction() override;

			[[nodiscard]] QString identifier() const override;
			[[nodiscard]] QString displayName() const override;
	};

	class PlaylistGeneratorPreferenceAction :
		public Gui::PreferenceAction
	{
		Q_OBJECT

		public:
			explicit PlaylistGeneratorPreferenceAction(QWidget* parent);
			~PlaylistGeneratorPreferenceAction() override;

			[[nodiscard]] QString identifier() const override;
			[[nodiscard]] QString displayName() const override;
	};
}

#endif // PREFERENCEACTION_H
