/* misc.h - Various functions that do not have a proper file (yet)
 * 
 * Copyright (C) 2004, 2005 Anderson Lizardo
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#define DEBUG_DECLARE_ONLY
#include "geniusvp2.h"
#include "geniusvp2-image.h"

#define TIMEOUT                   1
#define NO_TIMEOUT                0

#ifndef timercmp
#define timercmp(a, b, CMP)                              \
(((a)->tv_sec == (b)->tv_sec) ?                         \
 ((a)->tv_usec CMP (b)->tv_usec) :                          \
 ((a)->tv_sec CMP (b)->tv_sec))
#endif

/* Optical resolution in dpi's */
#define OPT_RESOLUTION            600

typedef struct
{
    int top, left;              /* top-left corner coordinates, in pixels */
    int width, height;          /* width and height, in pixels */
} ScanArea;

typedef enum
{
    mStop = 0,
    mPause = 1,
    mForward = 2,
    mBackward = 3,
    mScan = 4,
    mAutoHome = 5,
    mScanMotorOff               /* mScan with motor power off, not an actual operation mode */
} operation_mode;

extern const unsigned char ccd_line_offset;

/* Default values from e1.ini */
extern const int max_exposure_time;
extern const int min_exposure_time;
extern const int motor_change;
extern const float left_leading;
extern const int back_step;

extern void get_fifo_count (size_t * count);
extern void sane_geniusvp2_go_home (void);
extern SANE_Bool sane_geniusvp2_is_lamp_on (void);
extern SANE_Status sane_geniusvp2_lamp_off (void);
extern SANE_Status sane_geniusvp2_lamp_on (void);
extern void sane_geniusvp2_move_carriage_forward (int distance);
extern void sane_geniusvp2_poll_12 (unsigned char val, unsigned char mask);
extern int sane_geniusvp2_read_scan_data (SANE_Byte * data, size_t size);
extern void sane_geniusvp2_reset_fifo (void);
extern SANE_Status sane_geniusvp2_prepare_scan (ScanArea area, int res);
extern void sane_geniusvp2_set_memory_addr (int addr);
extern void sane_geniusvp2_set_operation_mode (operation_mode mode);
extern void sane_geniusvp2_set_scan_area (ScanArea area);
extern void sane_geniusvp2_set_scan_params (int res);
extern ssize_t sane_geniusvp2_wait_fifo (size_t count);
