include(CMakePackageConfigHelpers)
write_basic_package_version_file(
	"${PROJECT_NAME}ConfigVersion.cmake"
	VERSION ${PROJECT_VERSION}
	COMPATIBILITY SameMajorVersion
)
configure_package_config_file(
	"${CMAKE_MODULE_PATH}/${PROJECT_NAME}Config.cmake.in"
	"${PROJECT_BINARY_DIR}/${PROJECT_NAME}Config.cmake"
	INSTALL_DESTINATION ${CMAKE_INSTALL_DATAROOTDIR}/${PROJECT_NAME}/cmake
)
install(FILES
	${CMAKE_CURRENT_BINARY_DIR}/${PROJECT_NAME}Config.cmake
	${CMAKE_CURRENT_BINARY_DIR}/${PROJECT_NAME}ConfigVersion.cmake
	DESTINATION ${CMAKE_INSTALL_DATAROOTDIR}/${PROJECT_NAME}/cmake
)

install(TARGETS ${PROJECT_NAME}
	EXPORT ${PROJECT_NAME}Targets
	INCLUDES DESTINATION ${CMAKE_INSTALL_INCLUDEDIR}
	RUNTIME DESTINATION ${CMAKE_INSTALL_BINDIR}
					COMPONENT ${PROJECT_NAME}_RunTime
	LIBRARY DESTINATION ${CMAKE_INSTALL_LIBDIR}
					COMPONENT ${PROJECT_NAME}_RunTime
# 					NAMELINK_COMPONENT ${PROJECT_NAME}_Development
	ARCHIVE DESTINATION ${CMAKE_INSTALL_LIBDIR}
					COMPONENT NAME}_Development
)

install(EXPORT ${PROJECT_NAME}Targets
	DESTINATION ${CMAKE_INSTALL_DATAROOTDIR}/${PROJECT_NAME}/cmake
	NAMESPACE ${PROJECT_NAME}::
	FILE ${PROJECT_NAME}Targets.cmake
	COMPONENT ${PROJECT_NAME}_Development
)