use std::fmt::Write;
use std::path::Path;

use chrono::offset::Utc;

use crate::utils::{UpdateMode, replace_region_in_file};

pub fn update_nightly() {
    // Update rust-toolchain nightly version
    let date = Utc::now().format("%Y-%m-%d").to_string();
    replace_region_in_file(
        UpdateMode::Change,
        Path::new("rust-toolchain.toml"),
        "# begin autogenerated nightly\n",
        "# end autogenerated nightly",
        |res| {
            writeln!(res, "channel = \"nightly-{date}\"").unwrap();
        },
    );

    // Update clippy_utils nightly version
    replace_region_in_file(
        UpdateMode::Change,
        Path::new("clippy_utils/README.md"),
        "<!-- begin autogenerated nightly -->\n",
        "<!-- end autogenerated nightly -->",
        |res| {
            writeln!(res, "```").unwrap();
            writeln!(res, "nightly-{date}").unwrap();
            writeln!(res, "```").unwrap();
        },
    );
}
