// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 2
// RUN: %clang_cc1 -x c -fopenmp -triple amdgcn-amd-amdhsa -aux-triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -internal-isystem %S/../../lib/Headers/openmp_wrappers -include __clang_openmp_device_functions.h -internal-isystem %S/../../lib/Headers/openmp_wrappers -internal-isystem %S/Inputs/include -emit-llvm %s -fopenmp-is-target-device  -o - | FileCheck %s --check-prefixes=CHECK,CHECK-C
// RUN: %clang_cc1 -x c++ -fopenmp -triple amdgcn-amd-amdhsa -aux-triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -internal-isystem %S/../../lib/Headers/openmp_wrappers -include __clang_openmp_device_functions.h -internal-isystem %S/../../lib/Headers/openmp_wrappers -internal-isystem %S/Inputs/include -emit-llvm %s -fopenmp-is-target-device  -o - | FileCheck %s --check-prefixes=CHECK,CHECK-CPP

// Test that we did not include <stdbool.h> in C, and OCKL functions using bool
// produce an i1

#ifdef __cplusplus
typedef bool ockl_bool;
#define EXTERN_C extern "C"
#else
typedef _Bool ockl_bool;
#define EXTERN_C
#endif

#pragma omp begin declare target

// CHECK-LABEL: define hidden float @test_fdot2
// CHECK-SAME: (<2 x half> noundef [[A:%.*]], <2 x half> noundef [[B:%.*]], float noundef [[C:%.*]], i1 noundef zeroext [[S:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[RETVAL:%.*]] = alloca float, align 4, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca <2 x half>, align 4, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca <2 x half>, align 4, addrspace(5)
// CHECK-NEXT:    [[C_ADDR:%.*]] = alloca float, align 4, addrspace(5)
// CHECK-NEXT:    [[S_ADDR:%.*]] = alloca i8, align 1, addrspace(5)
// CHECK-NEXT:    [[RETVAL_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[C_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[C_ADDR]] to ptr
// CHECK-NEXT:    [[S_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[S_ADDR]] to ptr
// CHECK-NEXT:    store <2 x half> [[A]], ptr [[A_ADDR_ASCAST]], align 4
// CHECK-NEXT:    store <2 x half> [[B]], ptr [[B_ADDR_ASCAST]], align 4
// CHECK-NEXT:    store float [[C]], ptr [[C_ADDR_ASCAST]], align 4
// CHECK-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[S]] to i8
// CHECK-NEXT:    store i8 [[FROMBOOL]], ptr [[S_ADDR_ASCAST]], align 1
// CHECK-NEXT:    [[TMP0:%.*]] = load <2 x half>, ptr [[A_ADDR_ASCAST]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = load <2 x half>, ptr [[B_ADDR_ASCAST]], align 4
// CHECK-NEXT:    [[TMP2:%.*]] = load float, ptr [[C_ADDR_ASCAST]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr [[S_ADDR_ASCAST]], align 1
// CHECK-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP3]] to i1
// CHECK-NEXT:    [[CALL:%.*]] = call float @__ockl_fdot2(<2 x half> noundef [[TMP0]], <2 x half> noundef [[TMP1]], float noundef [[TMP2]], i1 noundef zeroext [[TOBOOL]]) #[[ATTR2:[0-9]+]]
// CHECK-NEXT:    ret float [[CALL]]
//
EXTERN_C float test_fdot2(__2f16 a, __2f16 b, float c, ockl_bool s) {
  return __ockl_fdot2(a, b, c, s);
}


#ifndef __cplusplus

enum my_bool {
  false,
  true
};

// CHECK-C-LABEL: define hidden i32 @use_my_bool
// CHECK-C-SAME: (i32 noundef [[B:%.*]]) #[[ATTR0]] {
// CHECK-C-NEXT:  entry:
// CHECK-C-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-C-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-C-NEXT:    [[T:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-C-NEXT:    [[F:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-C-NEXT:    [[RETVAL_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL]] to ptr
// CHECK-C-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-C-NEXT:    [[T_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[T]] to ptr
// CHECK-C-NEXT:    [[F_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[F]] to ptr
// CHECK-C-NEXT:    store i32 [[B]], ptr [[B_ADDR_ASCAST]], align 4
// CHECK-C-NEXT:    store volatile i32 1, ptr [[T_ASCAST]], align 4
// CHECK-C-NEXT:    store volatile i32 0, ptr [[F_ASCAST]], align 4
// CHECK-C-NEXT:    [[TMP0:%.*]] = load i32, ptr [[B_ADDR_ASCAST]], align 4
// CHECK-C-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
// CHECK-C-NEXT:    [[LNOT:%.*]] = xor i1 [[TOBOOL]], true
// CHECK-C-NEXT:    [[LNOT_EXT:%.*]] = zext i1 [[LNOT]] to i32
// CHECK-C-NEXT:    ret i32 [[LNOT_EXT]]
//
enum my_bool use_my_bool(enum my_bool b) {
  volatile enum my_bool t = true;
  volatile enum my_bool f = false;

  return !b;
}

#endif



#pragma omp end declare target
//// NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
// CHECK-CPP: {{.*}}
