#!/bin/bash
#
# Copyright 2022 The Fuchsia Authors
#
# Licensed under a BSD-style license <LICENSE-BSD>, Apache License, Version 2.0
# <LICENSE-APACHE or https://www.apache.org/licenses/LICENSE-2.0>, or the MIT
# license <LICENSE-MIT or https://opensource.org/licenses/MIT>, at your option.
# This file may not be copied, modified, or distributed except according to
# those terms.

set -eo pipefail

COPYRIGHT_HEADER=$(mktemp)
BODY=$(mktemp)
DISCLAIMER_FOOTER=$(mktemp)

cat > $COPYRIGHT_HEADER <<'EOF'
<!-- Copyright 2022 The Fuchsia Authors

Licensed under a BSD-style license <LICENSE-BSD>, Apache License, Version 2.0
<LICENSE-APACHE or https://www.apache.org/licenses/LICENSE-2.0>, or the MIT
license <LICENSE-MIT or https://opensource.org/licenses/MIT>, at your option.
This file may not be copied, modified, or distributed except according to
those terms.

WARNING: DO NOT EDIT THIS FILE. It is generated automatically. Edits should be
made in the doc comment on `src/lib.rs` or in `generate-readme.sh`.
-->

EOF

# This uses the `cargo readme` tool, which you can install via `cargo install
# cargo-readme --version 3.2.0`.
#
# The `sed` command is used to strip code links like:
#
#   /// Here is a link to [`Vec`].
#
# These links don't work in a Markdown file, and so we remove the `[` and `]`
# characters to convert them to non-link code snippets.
cargo readme --no-license | sed 's/\[\(`[^`]*`\)]/\1/g' > $BODY

cat > $DISCLAIMER_FOOTER <<'EOF'

## Disclaimer

Disclaimer: Zerocopy is not an officially supported Google product.
EOF

cat $COPYRIGHT_HEADER $BODY $DISCLAIMER_FOOTER
