# rb-sys

[![Join the discussion](https://img.shields.io/badge/slack-chat-blue.svg)](https://join.slack.com/t/oxidize-rb/shared_invite/zt-16zv5tqte-Vi7WfzxCesdo2TqF_RYBCw)

Autogenerated Rust bindings for Ruby. Uses the [`rust-bindgen`](https://github.com/rust-lang/rust-bindgen) crate to
generate bindings from the `ruby.h` header.https://github.com/rust-lang/rust-bindgen

## ⚠️ Notice

This is a very low-level library. If you are looking to write a gem in Rust, you should probably use
https://github.com/matsadler/magnus crate, with the `rb-sys-interop` feature.

If you actually _need_ raw/unsafe bindings to libruby, then this crate if for you!

## Usage

### Writing a Ruby gem

Ruby gems require a bit of boilerplate to be defined to be usable from Ruby. `rb-sys` makes this process painless by
doing the work for you, by simply enabling the `gem` feature.

```toml
rb-sys = "0.9"
```

Under the hood this ensures we do not link libruby (unless on Windows), and defines a `ruby_abi_version` function for
Ruby 3.2+.

[See this example of creating a Ruby gem in Rust](./examples/rust_reverse)

### Embedding libruby in your Rust app

_IMPORTANT_: If you are authoring a Ruby gem, you do not need to enable this feature.

If you need to link libruby (i.e. you are initializing a Ruby VM in your Rust code), use can enable the `link-ruby`
feature:

```toml
rb-sys = { version = "0.9",  features = ["link-ruby"] }
```

### Static libruby

You can also force static linking of libruby:

```toml
rb-sys = { version = "0.9", features = ["ruby-static"] }
```

Alternatively, you can set the `RUBY_STATIC=true` environment variable.

### Other features

- `global-allocator`: Report Rust memory allocations to the Ruby GC (_recommended_).
- `ruby-static`: Link the static version of libruby.
- `link-ruby`: Link libruby.
- `bindgen-rbimpls`: Include the Ruby impl types in bindings.
- `bindgen-deprecated-types`: Include deprecated Ruby methods in bindings.

## License

Licensed under either of

- Apache License, Version 2.0, ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
- MIT license ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

### Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted for inclusion in the work by you, as
defined in the Apache-2.0 license, shall be dual licensed as above, without any additional terms or conditions.
