# IndieWeb Library

A Rust library for implementing IndieWeb standards and algorithms.

## Overview

Provides tools for IndieWeb protocols including authentication, publishing, and communication standards.

## Installation

Install from crates.io for stable releases:

```bash
cargo add indieweb
```

Or from Git for the latest development version:

```bash
cargo add --git https://git.sr.ht/~jacky/indieweb-rust indieweb
```

## Modules

- **Algorithms**: Link resolution, authorship detection, representative h-card parsing
- **Standards**: IndieAuth, Micropub, Webmention, WebSub implementations
- **Traits**: Common interfaces for IndieWeb interactions

## Usage

For local development, add to your Cargo.toml:

```toml
[dependencies]
indieweb = { path = "../path/to/library" }
```

For detailed API usage, see the source code.