///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef.h"
#include "rheolef/hazel_1d.h"
using namespace rheolef;
using namespace std;


Float f (const point& x) { return x[0]; }

int main (int argc, char**argv) {
  geo Ih (argv[1]);
  // low level usage
  hazel_1d connec(Ih.data());
  cout << "n_connected = " << connec.size() << endl;
  cout << "connected(0).size = " << connec[0].size() << endl;
  if (argc >= 3) {
    Float x = atof(argv[2]);
    size_t k = connec.localize(Ih.data(),x);
    cout << "element " << k << " contains " << x << endl;
    Float y;
    connec.localize_nearest(Ih.data(),x,y,k);
    cout << "nearest element: " << k << ", near point " << y << endl;
  }
  if (argc >= 4) {
    Float x = atof(argv[2]);
    Float v = atof(argv[3]);
    Float y, t;
    size_t k;
    connec.trace(Ih.data(),x,v,y,t,k);
    cout << "trace: x+v=" << x+v << " : near element " << k << ", near point " << y << endl;
    cout << "such that :y=x+t*v with t = " << t << endl;
  }
  // advanced syntax
  geo Jh (argv[1]);
  space Vh (Jh, "P2");
  field fh = interpolate (Vh, f);
  cout << "fh(0) = " << fh(point(0)) << endl;
  cout << "fh(0.5) = " << fh(point(0.5)) << endl;
  cout << "fh(1) = " << fh(point(1)) << endl;
  cout << fh;
  field gh = interpolate (Vh, fh);
  cout << gh;
}
