/* ttyproto.h - define protocol used by ttysrv and its clients
 * vix 29may91 [written]
 *
 * $Id: ttyprot.h,v 1.9 2001/03/24 21:14:31 vixie Exp $
 */

/* Copyright (c) 1996 by Internet Software Consortium.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL INTERNET SOFTWARE
 * CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <termios.h>
#ifdef NEED_BITYPES_H
# include "bitypes.h"
#endif

#define TP_TYPEMASK	0x00ff
#define	TP_DATA		0x0001	/* inband data (query=ignored) */
#define	TP_BAUD		0x0002
#define	TP_PARITY	0x0003
#define	TP_WORDSIZE	0x0004
#define	TP_BREAK	0x0005	/* send break (query=ignored) */
#define	TP_WHOSON	0x0006	/* who's connected to this tty? (set=="me") */
#define	TP_TAIL		0x0007	/* what's happened recently? (set==ignored) */
#define	TP_NOTICE	0x0008	/* same as DATA but generated by server */
#define	TP_VERSION	0x0009	/* what's your version number? (set==ignore) */
#define	TP_LOGIN	0x000a
#define	TP_PASSWD	0x000b	/* query's "i" field is the salt (netorder) */

#define	TP_OPTIONMASK	0xff00
#define TP_QUERY	0x0100

#define	TP_FIXED	(sizeof(u_int16_t) + sizeof(u_int16_t))
#define	TP_MAXVAR	468	/* 512 - 40 - TP_FIXED */

typedef struct ttyprot {
	u_int16_t	f;
	u_int16_t	i;
	u_char		c[TP_MAXVAR];
} ttyprot;

int tp_senddata(int, const u_char *, int, int);
int tp_sendctl(int, u_int, u_int, u_char *);
int tp_getdata(int, ttyprot *);
