# Code to generate the 600-cell as a Regina triangulation.
#
# This code is not built into Regina, and is here for reference only.
# It was used to extract the isomorphism signature for the 600-cell,
# which is now hard-coded into the implementation of the C++ routine
# NExampleTriangulation::sphere600().
#
# The simplicial complex described in cell[] was extracted from the
# Benedetti-Lutz library of triangulations.  See:
#
# http://page.math.tu-berlin.de/~lutz/stellar/library_of_triangulations.html
# http://page.math.tu-berlin.de/~lutz/stellar/library_of_triangulations/600_cell
#
# Thanks also to Jonathan Spreer, from whose code the routine simpToReg()
# was adapted.
#
# - Ben Burton, 17 June 2014.

from regina import *

cell=[ [ 1, 2, 3, 4 ], [ 1, 2, 3, 5 ], [ 1, 2, 4, 6 ], [ 1, 2, 5, 7 ], [ 1, 2, 6, 7 ], [ 1, 3, 4, 8 ], [ 1, 3, 5, 9 ], [ 1, 3, 8, 9 ], [ 1, 4, 6, 10 ], [ 1, 4, 8, 10 ], [ 1, 5, 7, 11 ], [ 1, 5, 9, 11 ], [ 1, 6, 7, 12 ], [ 1, 6, 10, 12 ], [ 1, 7, 11, 12 ], [ 1, 8, 9, 13 ], [ 1, 8, 10, 13 ], [ 1, 9, 11, 13 ], [ 1, 10, 12, 13 ], [ 1, 11, 12, 13 ], [ 2, 3, 4, 14 ], [ 2, 3, 5, 15 ], [ 2, 3, 14, 15 ], [ 2, 4, 6, 16 ], [ 2, 4, 14, 16 ], [ 2, 5, 7, 17 ], [ 2, 5, 15, 17 ], [ 2, 6, 7, 18 ], [ 2, 6, 16, 18 ], [ 2, 7, 17, 18 ], [ 2, 14, 15, 19 ], [ 2, 14, 16, 19 ], [ 2, 15, 17, 19 ], [ 2, 16, 18, 19 ], [ 2, 17, 18, 19 ], [ 3, 4, 8, 20 ], [ 3, 4, 14, 20 ], [ 3, 5, 9, 21 ], [ 3, 5, 15, 21 ], [ 3, 8, 9, 22 ], [ 3, 8, 20, 22 ], [ 3, 9, 21, 22 ], [ 3, 14, 15, 23 ], [ 3, 14, 20, 23 ], [ 3, 15, 21, 23 ], [ 3, 20, 22, 23 ], [ 3, 21, 22, 23 ], [ 4, 6, 10, 24 ], [ 4, 6, 16, 24 ], [ 4, 8, 10, 25 ], [ 4, 8, 20, 25 ], [ 4, 10, 24, 25 ], [ 4, 14, 16, 26 ], [ 4, 14, 20, 26 ], [ 4, 16, 24, 26 ], [ 4, 20, 25, 26 ], [ 4, 24, 25, 26 ], [ 5, 7, 11, 27 ], [ 5, 7, 17, 27 ], [ 5, 9, 11, 28 ], [ 5, 9, 21, 28 ], [ 5, 11, 27, 28 ], [ 5, 15, 17, 29 ], [ 5, 15, 21, 29 ], [ 5, 17, 27, 29 ], [ 5, 21, 28, 29 ], [ 5, 27, 28, 29 ], [ 6, 7, 12, 30 ], [ 6, 7, 18, 30 ], [ 6, 10, 12, 31 ], [ 6, 10, 24, 31 ], [ 6, 12, 30, 31 ], [ 6, 16, 18, 32 ], [ 6, 16, 24, 32 ], [ 6, 18, 30, 32 ], [ 6, 24, 31, 32 ], [ 6, 30, 31, 32 ], [ 7, 11, 12, 33 ], [ 7, 11, 27, 33 ], [ 7, 12, 30, 33 ], [ 7, 17, 18, 34 ], [ 7, 17, 27, 34 ], [ 7, 18, 30, 34 ], [ 7, 27, 33, 34 ], [ 7, 30, 33, 34 ], [ 8, 9, 13, 35 ], [ 8, 9, 22, 35 ], [ 8, 10, 13, 36 ], [ 8, 10, 25, 36 ], [ 8, 13, 35, 36 ], [ 8, 20, 22, 37 ], [ 8, 20, 25, 37 ], [ 8, 22, 35, 37 ], [ 8, 25, 36, 37 ], [ 8, 35, 36, 37 ], [ 9, 11, 13, 38 ], [ 9, 11, 28, 38 ], [ 9, 13, 35, 38 ], [ 9, 21, 22, 39 ], [ 9, 21, 28, 39 ], [ 9, 22, 35, 39 ], [ 9, 28, 38, 39 ], [ 9, 35, 38, 39 ], [ 10, 12, 13, 40 ], [ 10, 12, 31, 40 ], [ 10, 13, 36, 40 ], [ 10, 24, 25, 41 ], [ 10, 24, 31, 41 ], [ 10, 25, 36, 41 ], [ 10, 31, 40, 41 ], [ 10, 36, 40, 41 ], [ 11, 12, 13, 42 ], [ 11, 12, 33, 42 ], [ 11, 13, 38, 42 ], [ 11, 27, 28, 43 ], [ 11, 27, 33, 43 ], [ 11, 28, 38, 43 ], [ 11, 33, 42, 43 ], [ 11, 38, 42, 43 ], [ 12, 13, 40, 42 ], [ 12, 30, 31, 44 ], [ 12, 30, 33, 44 ], [ 12, 31, 40, 44 ], [ 12, 33, 42, 44 ], [ 12, 40, 42, 44 ], [ 13, 35, 36, 45 ], [ 13, 35, 38, 45 ], [ 13, 36, 40, 45 ], [ 13, 38, 42, 45 ], [ 13, 40, 42, 45 ], [ 14, 15, 19, 46 ], [ 14, 15, 23, 46 ], [ 14, 16, 19, 47 ], [ 14, 16, 26, 47 ], [ 14, 19, 46, 47 ], [ 14, 20, 23, 48 ], [ 14, 20, 26, 48 ], [ 14, 23, 46, 48 ], [ 14, 26, 47, 48 ], [ 14, 46, 47, 48 ], [ 15, 17, 19, 49 ], [ 15, 17, 29, 49 ], [ 15, 19, 46, 49 ], [ 15, 21, 23, 50 ], [ 15, 21, 29, 50 ], [ 15, 23, 46, 50 ], [ 15, 29, 49, 50 ], [ 15, 46, 49, 50 ], [ 16, 18, 19, 51 ], [ 16, 18, 32, 51 ], [ 16, 19, 47, 51 ], [ 16, 24, 26, 52 ], [ 16, 24, 32, 52 ], [ 16, 26, 47, 52 ], [ 16, 32, 51, 52 ], [ 16, 47, 51, 52 ], [ 17, 18, 19, 53 ], [ 17, 18, 34, 53 ], [ 17, 19, 49, 53 ], [ 17, 27, 29, 54 ], [ 17, 27, 34, 54 ], [ 17, 29, 49, 54 ], [ 17, 34, 53, 54 ], [ 17, 49, 53, 54 ], [ 18, 19, 51, 53 ], [ 18, 30, 32, 55 ], [ 18, 30, 34, 55 ], [ 18, 32, 51, 55 ], [ 18, 34, 53, 55 ], [ 18, 51, 53, 55 ], [ 19, 46, 47, 56 ], [ 19, 46, 49, 56 ], [ 19, 47, 51, 56 ], [ 19, 49, 53, 56 ], [ 19, 51, 53, 56 ], [ 20, 22, 23, 57 ], [ 20, 22, 37, 57 ], [ 20, 23, 48, 57 ], [ 20, 25, 26, 58 ], [ 20, 25, 37, 58 ], [ 20, 26, 48, 58 ], [ 20, 37, 57, 58 ], [ 20, 48, 57, 58 ], [ 21, 22, 23, 59 ], [ 21, 22, 39, 59 ], [ 21, 23, 50, 59 ], [ 21, 28, 29, 60 ], [ 21, 28, 39, 60 ], [ 21, 29, 50, 60 ], [ 21, 39, 59, 60 ], [ 21, 50, 59, 60 ], [ 22, 23, 57, 59 ], [ 22, 35, 37, 61 ], [ 22, 35, 39, 61 ], [ 22, 37, 57, 61 ], [ 22, 39, 59, 61 ], [ 22, 57, 59, 61 ], [ 23, 46, 48, 62 ], [ 23, 46, 50, 62 ], [ 23, 48, 57, 62 ], [ 23, 50, 59, 62 ], [ 23, 57, 59, 62 ], [ 24, 25, 26, 63 ], [ 24, 25, 41, 63 ], [ 24, 26, 52, 63 ], [ 24, 31, 32, 64 ], [ 24, 31, 41, 64 ], [ 24, 32, 52, 64 ], [ 24, 41, 63, 64 ], [ 24, 52, 63, 64 ], [ 25, 26, 58, 63 ], [ 25, 36, 37, 65 ], [ 25, 36, 41, 65 ], [ 25, 37, 58, 65 ], [ 25, 41, 63, 65 ], [ 25, 58, 63, 65 ], [ 26, 47, 48, 66 ], [ 26, 47, 52, 66 ], [ 26, 48, 58, 66 ], [ 26, 52, 63, 66 ], [ 26, 58, 63, 66 ], [ 27, 28, 29, 67 ], [ 27, 28, 43, 67 ], [ 27, 29, 54, 67 ], [ 27, 33, 34, 68 ], [ 27, 33, 43, 68 ], [ 27, 34, 54, 68 ], [ 27, 43, 67, 68 ], [ 27, 54, 67, 68 ], [ 28, 29, 60, 67 ], [ 28, 38, 39, 69 ], [ 28, 38, 43, 69 ], [ 28, 39, 60, 69 ], [ 28, 43, 67, 69 ], [ 28, 60, 67, 69 ], [ 29, 49, 50, 70 ], [ 29, 49, 54, 70 ], [ 29, 50, 60, 70 ], [ 29, 54, 67, 70 ], [ 29, 60, 67, 70 ], [ 30, 31, 32, 71 ], [ 30, 31, 44, 71 ], [ 30, 32, 55, 71 ], [ 30, 33, 34, 72 ], [ 30, 33, 44, 72 ], [ 30, 34, 55, 72 ], [ 30, 44, 71, 72 ], [ 30, 55, 71, 72 ], [ 31, 32, 64, 71 ], [ 31, 40, 41, 73 ], [ 31, 40, 44, 73 ], [ 31, 41, 64, 73 ], [ 31, 44, 71, 73 ], [ 31, 64, 71, 73 ], [ 32, 51, 52, 74 ], [ 32, 51, 55, 74 ], [ 32, 52, 64, 74 ], [ 32, 55, 71, 74 ], [ 32, 64, 71, 74 ], [ 33, 34, 68, 72 ], [ 33, 42, 43, 75 ], [ 33, 42, 44, 75 ], [ 33, 43, 68, 75 ], [ 33, 44, 72, 75 ], [ 33, 68, 72, 75 ], [ 34, 53, 54, 76 ], [ 34, 53, 55, 76 ], [ 34, 54, 68, 76 ], [ 34, 55, 72, 76 ], [ 34, 68, 72, 76 ], [ 35, 36, 37, 77 ], [ 35, 36, 45, 77 ], [ 35, 37, 61, 77 ], [ 35, 38, 39, 78 ], [ 35, 38, 45, 78 ], [ 35, 39, 61, 78 ], [ 35, 45, 77, 78 ], [ 35, 61, 77, 78 ], [ 36, 37, 65, 77 ], [ 36, 40, 41, 79 ], [ 36, 40, 45, 79 ], [ 36, 41, 65, 79 ], [ 36, 45, 77, 79 ], [ 36, 65, 77, 79 ], [ 37, 57, 58, 80 ], [ 37, 57, 61, 80 ], [ 37, 58, 65, 80 ], [ 37, 61, 77, 80 ], [ 37, 65, 77, 80 ], [ 38, 39, 69, 78 ], [ 38, 42, 43, 81 ], [ 38, 42, 45, 81 ], [ 38, 43, 69, 81 ], [ 38, 45, 78, 81 ], [ 38, 69, 78, 81 ], [ 39, 59, 60, 82 ], [ 39, 59, 61, 82 ], [ 39, 60, 69, 82 ], [ 39, 61, 78, 82 ], [ 39, 69, 78, 82 ], [ 40, 41, 73, 79 ], [ 40, 42, 44, 83 ], [ 40, 42, 45, 83 ], [ 40, 44, 73, 83 ], [ 40, 45, 79, 83 ], [ 40, 73, 79, 83 ], [ 41, 63, 64, 84 ], [ 41, 63, 65, 84 ], [ 41, 64, 73, 84 ], [ 41, 65, 79, 84 ], [ 41, 73, 79, 84 ], [ 42, 43, 75, 81 ], [ 42, 44, 75, 83 ], [ 42, 45, 81, 83 ], [ 42, 75, 81, 83 ], [ 43, 67, 68, 85 ], [ 43, 67, 69, 85 ], [ 43, 68, 75, 85 ], [ 43, 69, 81, 85 ], [ 43, 75, 81, 85 ], [ 44, 71, 72, 86 ], [ 44, 71, 73, 86 ], [ 44, 72, 75, 86 ], [ 44, 73, 83, 86 ], [ 44, 75, 83, 86 ], [ 45, 77, 78, 87 ], [ 45, 77, 79, 87 ], [ 45, 78, 81, 87 ], [ 45, 79, 83, 87 ], [ 45, 81, 83, 87 ], [ 46, 47, 48, 88 ], [ 46, 47, 56, 88 ], [ 46, 48, 62, 88 ], [ 46, 49, 50, 89 ], [ 46, 49, 56, 89 ], [ 46, 50, 62, 89 ], [ 46, 56, 88, 89 ], [ 46, 62, 88, 89 ], [ 47, 48, 66, 88 ], [ 47, 51, 52, 90 ], [ 47, 51, 56, 90 ], [ 47, 52, 66, 90 ], [ 47, 56, 88, 90 ], [ 47, 66, 88, 90 ], [ 48, 57, 58, 91 ], [ 48, 57, 62, 91 ], [ 48, 58, 66, 91 ], [ 48, 62, 88, 91 ], [ 48, 66, 88, 91 ], [ 49, 50, 70, 89 ], [ 49, 53, 54, 92 ], [ 49, 53, 56, 92 ], [ 49, 54, 70, 92 ], [ 49, 56, 89, 92 ], [ 49, 70, 89, 92 ], [ 50, 59, 60, 93 ], [ 50, 59, 62, 93 ], [ 50, 60, 70, 93 ], [ 50, 62, 89, 93 ], [ 50, 70, 89, 93 ], [ 51, 52, 74, 90 ], [ 51, 53, 55, 94 ], [ 51, 53, 56, 94 ], [ 51, 55, 74, 94 ], [ 51, 56, 90, 94 ], [ 51, 74, 90, 94 ], [ 52, 63, 64, 95 ], [ 52, 63, 66, 95 ], [ 52, 64, 74, 95 ], [ 52, 66, 90, 95 ], [ 52, 74, 90, 95 ], [ 53, 54, 76, 92 ], [ 53, 55, 76, 94 ], [ 53, 56, 92, 94 ], [ 53, 76, 92, 94 ], [ 54, 67, 68, 96 ], [ 54, 67, 70, 96 ], [ 54, 68, 76, 96 ], [ 54, 70, 92, 96 ], [ 54, 76, 92, 96 ], [ 55, 71, 72, 97 ], [ 55, 71, 74, 97 ], [ 55, 72, 76, 97 ], [ 55, 74, 94, 97 ], [ 55, 76, 94, 97 ], [ 56, 88, 89, 98 ], [ 56, 88, 90, 98 ], [ 56, 89, 92, 98 ], [ 56, 90, 94, 98 ], [ 56, 92, 94, 98 ], [ 57, 58, 80, 91 ], [ 57, 59, 61, 99 ], [ 57, 59, 62, 99 ], [ 57, 61, 80, 99 ], [ 57, 62, 91, 99 ], [ 57, 80, 91, 99 ], [ 58, 63, 65, 100 ], [ 58, 63, 66, 100 ], [ 58, 65, 80, 100 ], [ 58, 66, 91, 100 ], [ 58, 80, 91, 100 ], [ 59, 60, 82, 93 ], [ 59, 61, 82, 99 ], [ 59, 62, 93, 99 ], [ 59, 82, 93, 99 ], [ 60, 67, 69, 101 ], [ 60, 67, 70, 101 ], [ 60, 69, 82, 101 ], [ 60, 70, 93, 101 ], [ 60, 82, 93, 101 ], [ 61, 77, 78, 102 ], [ 61, 77, 80, 102 ], [ 61, 78, 82, 102 ], [ 61, 80, 99, 102 ], [ 61, 82, 99, 102 ], [ 62, 88, 89, 103 ], [ 62, 88, 91, 103 ], [ 62, 89, 93, 103 ], [ 62, 91, 99, 103 ], [ 62, 93, 99, 103 ], [ 63, 64, 84, 95 ], [ 63, 65, 84, 100 ], [ 63, 66, 95, 100 ], [ 63, 84, 95, 100 ], [ 64, 71, 73, 104 ], [ 64, 71, 74, 104 ], [ 64, 73, 84, 104 ], [ 64, 74, 95, 104 ], [ 64, 84, 95, 104 ], [ 65, 77, 79, 105 ], [ 65, 77, 80, 105 ], [ 65, 79, 84, 105 ], [ 65, 80, 100, 105 ], [ 65, 84, 100, 105 ], [ 66, 88, 90, 106 ], [ 66, 88, 91, 106 ], [ 66, 90, 95, 106 ], [ 66, 91, 100, 106 ], [ 66, 95, 100, 106 ], [ 67, 68, 85, 96 ], [ 67, 69, 85, 101 ], [ 67, 70, 96, 101 ], [ 67, 85, 96, 101 ], [ 68, 72, 75, 107 ], [ 68, 72, 76, 107 ], [ 68, 75, 85, 107 ], [ 68, 76, 96, 107 ], [ 68, 85, 96, 107 ], [ 69, 78, 81, 108 ], [ 69, 78, 82, 108 ], [ 69, 81, 85, 108 ], [ 69, 82, 101, 108 ], [ 69, 85, 101, 108 ], [ 70, 89, 92, 109 ], [ 70, 89, 93, 109 ], [ 70, 92, 96, 109 ], [ 70, 93, 101, 109 ], [ 70, 96, 101, 109 ], [ 71, 72, 86, 97 ], [ 71, 73, 86, 104 ], [ 71, 74, 97, 104 ], [ 71, 86, 97, 104 ], [ 72, 75, 86, 107 ], [ 72, 76, 97, 107 ], [ 72, 86, 97, 107 ], [ 73, 79, 83, 110 ], [ 73, 79, 84, 110 ], [ 73, 83, 86, 110 ], [ 73, 84, 104, 110 ], [ 73, 86, 104, 110 ], [ 74, 90, 94, 111 ], [ 74, 90, 95, 111 ], [ 74, 94, 97, 111 ], [ 74, 95, 104, 111 ], [ 74, 97, 104, 111 ], [ 75, 81, 83, 112 ], [ 75, 81, 85, 112 ], [ 75, 83, 86, 112 ], [ 75, 85, 107, 112 ], [ 75, 86, 107, 112 ], [ 76, 92, 94, 113 ], [ 76, 92, 96, 113 ], [ 76, 94, 97, 113 ], [ 76, 96, 107, 113 ], [ 76, 97, 107, 113 ], [ 77, 78, 87, 102 ], [ 77, 79, 87, 105 ], [ 77, 80, 102, 105 ], [ 77, 87, 102, 105 ], [ 78, 81, 87, 108 ], [ 78, 82, 102, 108 ], [ 78, 87, 102, 108 ], [ 79, 83, 87, 110 ], [ 79, 84, 105, 110 ], [ 79, 87, 105, 110 ], [ 80, 91, 99, 114 ], [ 80, 91, 100, 114 ], [ 80, 99, 102, 114 ], [ 80, 100, 105, 114 ], [ 80, 102, 105, 114 ], [ 81, 83, 87, 112 ], [ 81, 85, 108, 112 ], [ 81, 87, 108, 112 ], [ 82, 93, 99, 115 ], [ 82, 93, 101, 115 ], [ 82, 99, 102, 115 ], [ 82, 101, 108, 115 ], [ 82, 102, 108, 115 ], [ 83, 86, 110, 112 ], [ 83, 87, 110, 112 ], [ 84, 95, 100, 116 ], [ 84, 95, 104, 116 ], [ 84, 100, 105, 116 ], [ 84, 104, 110, 116 ], [ 84, 105, 110, 116 ], [ 85, 96, 101, 117 ], [ 85, 96, 107, 117 ], [ 85, 101, 108, 117 ], [ 85, 107, 112, 117 ], [ 85, 108, 112, 117 ], [ 86, 97, 104, 118 ], [ 86, 97, 107, 118 ], [ 86, 104, 110, 118 ], [ 86, 107, 112, 118 ], [ 86, 110, 112, 118 ], [ 87, 102, 105, 119 ], [ 87, 102, 108, 119 ], [ 87, 105, 110, 119 ], [ 87, 108, 112, 119 ], [ 87, 110, 112, 119 ], [ 88, 89, 98, 103 ], [ 88, 90, 98, 106 ], [ 88, 91, 103, 106 ], [ 88, 98, 103, 106 ], [ 89, 92, 98, 109 ], [ 89, 93, 103, 109 ], [ 89, 98, 103, 109 ], [ 90, 94, 98, 111 ], [ 90, 95, 106, 111 ], [ 90, 98, 106, 111 ], [ 91, 99, 103, 114 ], [ 91, 100, 106, 114 ], [ 91, 103, 106, 114 ], [ 92, 94, 98, 113 ], [ 92, 96, 109, 113 ], [ 92, 98, 109, 113 ], [ 93, 99, 103, 115 ], [ 93, 101, 109, 115 ], [ 93, 103, 109, 115 ], [ 94, 97, 111, 113 ], [ 94, 98, 111, 113 ], [ 95, 100, 106, 116 ], [ 95, 104, 111, 116 ], [ 95, 106, 111, 116 ], [ 96, 101, 109, 117 ], [ 96, 107, 113, 117 ], [ 96, 109, 113, 117 ], [ 97, 104, 111, 118 ], [ 97, 107, 113, 118 ], [ 97, 111, 113, 118 ], [ 98, 103, 106, 120 ], [ 98, 103, 109, 120 ], [ 98, 106, 111, 120 ], [ 98, 109, 113, 120 ], [ 98, 111, 113, 120 ], [ 99, 102, 114, 115 ], [ 99, 103, 114, 115 ], [ 100, 105, 114, 116 ], [ 100, 106, 114, 116 ], [ 101, 108, 115, 117 ], [ 101, 109, 115, 117 ], [ 102, 105, 114, 119 ], [ 102, 108, 115, 119 ], [ 102, 114, 115, 119 ], [ 103, 106, 114, 120 ], [ 103, 109, 115, 120 ], [ 103, 114, 115, 120 ], [ 104, 110, 116, 118 ], [ 104, 111, 116, 118 ], [ 105, 110, 116, 119 ], [ 105, 114, 116, 119 ], [ 106, 111, 116, 120 ], [ 106, 114, 116, 120 ], [ 107, 112, 117, 118 ], [ 107, 113, 117, 118 ], [ 108, 112, 117, 119 ], [ 108, 115, 117, 119 ], [ 109, 113, 117, 120 ], [ 109, 115, 117, 120 ], [ 110, 112, 118, 119 ], [ 110, 116, 118, 119 ], [ 111, 113, 118, 120 ], [ 111, 116, 118, 120 ], [ 112, 117, 118, 119 ], [ 113, 117, 118, 120 ], [ 114, 115, 119, 120 ], [ 114, 116, 119, 120 ], [ 115, 117, 119, 120 ], [ 116, 118, 119, 120 ], [ 117, 118, 119, 120 ] ]

facets = [[1,2,3], [0,2,3], [0,1,3], [0,1,2]]

def simpToReg(simp):
    n = len(simp)

    neighbours = []
    gluings = []

    for j in range(n):
        neighbours.append([None] * 4)
        gluings.append([None] * 4)

        for f in range(4):
            found = False
            for k in range(n):
                if k == j:
                    continue
                good = True
                for i in range(3):
                    if simp[j][facets[f][i]] not in simp[k]:
                        good = False
                        break
                if not good:
                    continue
                found = True
                break
            if not found:
                return None

            neighbours[j][f] = k
            tmp = [None] * 4

            unused = 6
            for i in range(3):
                adj = simp[k].index(simp[j][facets[f][i]])
                tmp[facets[f][i]] = adj
                unused = unused - adj
            tmp[f] = unused

            gluings[j][f] = regina.NPerm4(tmp[0], tmp[1], tmp[2], tmp[3])

    ans = regina.NTriangulation()
    for j in range(n):
        ans.newTetrahedron()
    for j in range(n):
        for f in range(4):
            if ans.getTetrahedron(j).adjacentTetrahedron(f) == None:
                ans.getTetrahedron(j).joinTo(f,
                    ans.getTetrahedron(neighbours[j][f]), gluings[j][f])
    return ans

print simpToReg(cell).isoSig()
