/* --- Generated by Rapicorn-CxxPyStub --- */

#include <Python.h> // must be included first to configure std headers
#include <string>

#include <rapicorn.hh>

#define None_INCREF()   ({ Py_INCREF (Py_None); Py_None; })
#define GOTO_ERROR()    goto error
#define ERRORif(cond)   if (cond) goto error
#define ERRORifpy()     if (PyErr_Occurred()) goto error
#define ERRORpy(msg)    do { PyErr_Format (PyExc_RuntimeError, msg); goto error; } while (0)
#define ERRORifnotret(fr) do { if (AIDA_UNLIKELY (!fr) || \
                                   AIDA_UNLIKELY (!Rapicorn::Aida::msgid_is_result (Rapicorn::Aida::MessageId (fr->first_id())))) { \
                                 PyErr_Format_from_AIDA_error (fr); \
                                 goto error; } } while (0)
#define ERROR_callable_ifpy(callable) do { if (PyErr_Occurred()) { \
  PyObject *t, *v, *tb; \
  PyErr_Fetch (&t, &v, &tb); \
  PyObject *sc = PyObject_Repr (callable), *sv = PyObject_Str (v); \
  PyErr_Format (PyExceptionClass_Check (t) ? t : PyExc_RuntimeError, \
                "in return from %s: %s", PyString_AsString (sc), PyString_AsString (sv)); \
  Py_XDECREF (sc); Py_XDECREF (sv); Py_XDECREF (t); Py_XDECREF (v); Py_XDECREF (tb); \
  goto error; \
} } while (0)

#ifndef __AIDA_PYMODULE__OBJECT
#define __AIDA_PYMODULE__OBJECT ((PyObject*) NULL)
#endif

using Rapicorn::Aida::uint64;
using Rapicorn::Aida::FieldBuffer;
using Rapicorn::Aida::FieldReader;

// connection
static Rapicorn::Aida::ClientConnection *__AIDA_local__client_connection = NULL;

// connection initialization
static Rapicorn::Init __AIDA_init__client_connection ([]() {
  __AIDA_local__client_connection = Rapicorn::Aida::ObjectBroker::new_client_connection (":AidaClientConnection:PyStub:idl_file=aidacc/tests/testpass.idl:");
});

// helpers
static PyObject*
PyErr_Format_from_AIDA_error (const FieldBuffer *fr)
{
  if (!fr)
    return PyErr_Format (PyExc_RuntimeError, "Aida: missing return value");
  FieldReader frr (*fr);
  const uint64 msgid AIDA_UNUSED = frr.pop_int64();
  frr.skip(); frr.skip(); // hashhigh hashlow
#if 0
  if (Rapicorn::Aida::msgid_is_error (Rapicorn::Aida::MessageId (msgid)))
    {
      std::string msg = frr.pop_string(), domain = frr.pop_string();
      if (domain.size()) domain += ": ";
      msg = domain + msg;
      return PyErr_Format (PyExc_RuntimeError, "%s", msg.c_str());
    }
#endif
  return PyErr_Format (PyExc_RuntimeError, "Aida: garbage return: 0x%s", fr->first_id_str().c_str());
}

static inline PY_LONG_LONG
PyIntLong_AsLongLong (PyObject *intlong)
{
  if (PyInt_Check (intlong))
    return PyInt_AS_LONG (intlong);
  else
    return PyLong_AsLongLong (intlong);
}

static inline std::string
PyString_As_std_string (PyObject *pystr)
{
  char *s = NULL;
  Py_ssize_t len = 0;
  PyString_AsStringAndSize (pystr, &s, &len);
  return std::string (s, len);
}

static inline Rapicorn::Aida::uint64
PyAttr_As_uint64 (PyObject *pyobj, const char *attr_name)
{
  PyObject *pyo = PyObject_GetAttrString (pyobj, attr_name);
  Rapicorn::Aida::uint64 uval = pyo ? PyLong_AsUnsignedLongLong (pyo) : 0;
  Py_XDECREF (pyo);
  return uval;
}

static inline PyObject*
PyString_From_std_string (const std::string &s)
{
  return PyString_FromStringAndSize (s.data(), s.size());
}

static inline int
PyDict_Take_Item (PyObject *pydict, const char *key, PyObject **pyitemp)
{
  int r = PyDict_SetItemString (pydict, key, *pyitemp);
  if (r >= 0)
    {
      Py_DECREF (*pyitemp);
      *pyitemp = NULL;
    }
  return r;
}

static void
__AIDA_pyconvert__pyany_to_any (Rapicorn::Aida::Any &any, PyObject *pyvalue)
{
  if (pyvalue == Py_None)               any.retype (Rapicorn::Aida::TypeMap::notype());
  else if (PyString_Check (pyvalue))    any <<= PyString_As_std_string (pyvalue);
  else if (PyBool_Check (pyvalue))      any <<= bool (pyvalue == Py_True);
  else if (PyInt_Check (pyvalue))       any <<= PyInt_AS_LONG (pyvalue);
  else if (PyLong_Check (pyvalue))      any <<= PyLong_AsLongLong (pyvalue);
  else if (PyFloat_Check (pyvalue))     any <<= PyFloat_AsDouble (pyvalue);
  else {
    std::string msg =
      Rapicorn::string_format ("no known conversion to Aida::Any for Python object: %s", PyObject_REPR (pyvalue));
    PyErr_SetString (PyExc_NotImplementedError, msg.c_str());
  }
}

static PyObject*
__AIDA_pyconvert__pyany_from_any (const Rapicorn::Aida::Any &any)
{
  using namespace Rapicorn::Aida;
  switch (any.kind())
    {
    case UNTYPED:                               return None_INCREF();
    case BOOL:          { bool b; any >>= b;    return PyBool_FromLong (b); }
    case ENUM:  // chain
    case INT32: // chain
    case INT64:                                 return PyLong_FromLongLong (any.as_int());
    case FLOAT64:                               return PyFloat_FromDouble (any.as_float());
    case STRING:                                return PyString_From_std_string (any.as_string());
    case SEQUENCE:      break;
    case RECORD:        break;
    case INSTANCE:      break;
    case ANY:           break;
    default:            break;
    }
  std::string msg =
    Rapicorn::string_format ("no known conversion for Aida::%s to Python", Rapicorn::Aida::type_kind_name (any.kind()));
  PyErr_SetString (PyExc_NotImplementedError, msg.c_str());
  return NULL;
}

static PyObject *__AIDA_pyfactory__create_pyobject__ = NULL;

static PyObject*
__AIDA_pyfactory__register_callback (PyObject *pyself, PyObject *pyargs)
{
  if (__AIDA_pyfactory__create_pyobject__)
    return PyErr_Format (PyExc_RuntimeError, "object_factory_callable already registered");
  if (PyTuple_Size (pyargs) != 1)
    return PyErr_Format (PyExc_RuntimeError, "wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);
  if (!PyCallable_Check (item))
    return PyErr_Format (PyExc_RuntimeError, "argument must be callable");
  Py_INCREF (item);
  __AIDA_pyfactory__create_pyobject__ = item;
  return None_INCREF();
}

static inline PyObject*
__AIDA_pyfactory__create_enum (const char *enum_name, uint64 enum_value)
{
  PyObject *result = NULL, *pyid;
  if (strchr (enum_name, ':'))
    goto unimplemented;
  if (!__AIDA_pyfactory__create_pyobject__)
    return PyErr_Format (PyExc_RuntimeError, "unregistered AIDA_pyfactory");
  pyid = PyLong_FromUnsignedLongLong (enum_value);
  if (pyid)
    {
      PyObject *tuple = PyTuple_New (2);
      if (tuple)
        {
          PyTuple_SET_ITEM (tuple, 0, PyString_FromString (enum_name));
          PyTuple_SET_ITEM (tuple, 1, pyid), pyid = NULL;
          result = PyObject_Call (__AIDA_pyfactory__create_pyobject__, tuple, NULL);
          Py_DECREF (tuple);
        }
      Py_XDECREF (pyid);
    }
  return result;
 unimplemented:
  Rapicorn::Aida::fatal_error (std::string() + "UNIMPLEMENTED: FIXME: missing handling of typenames outside the Rapicorn namespace: " + enum_name);
}

static inline PyObject*
__AIDA_pyfactory__create_from_orbid (uint64 orbid)
{
  PyObject *result = NULL, *pyid;
  const std::string fqtn = __AIDA_local__client_connection->type_name_from_orbid (orbid);
  std::string type_name = fqtn;
  size_t p = type_name.find ("::");
  while (p != std::string::npos)
    {
      type_name.replace (p, 2, ".");            // Foo::Bar::baz -> Foo.Bar.baz
      p = type_name.find ("::", p + 1);
    }
  if (!__AIDA_pyfactory__create_pyobject__)
    return PyErr_Format (PyExc_RuntimeError, "unregistered AIDA_pyfactory");
  pyid = PyLong_FromUnsignedLongLong (orbid);
  if (pyid)
    {
      PyObject *tuple = PyTuple_New (2);
      if (tuple)
        {
          PyTuple_SET_ITEM (tuple, 0, PyString_FromString (type_name.c_str()));
          PyTuple_SET_ITEM (tuple, 1, pyid), pyid = NULL;
          result = PyObject_Call (__AIDA_pyfactory__create_pyobject__, tuple, NULL);
          Py_DECREF (tuple);
        }
      Py_XDECREF (pyid);
    }
  return result;
}

struct XFooRecord;
struct NestedTypesRec;
struct NewRecord;
struct InnerRecord;
struct Refer2Inner;
struct SomeRecord;
struct QuickRecord;
struct RecordForGroups;
static RAPICORN_UNUSED bool
aida_pyXFooRecord_proto_add (PyObject *pyrec, Rapicorn::Aida::FieldBuffer &dst)
{
  Rapicorn::Aida::FieldBuffer &fb = dst.add_rec (18);
  bool success = false;
  PyObject *dictR = NULL, *item = NULL;
  dictR = PyObject_GetAttrString (pyrec, "__dict__"); ERRORif (!dictR);
  item = PyDict_GetItemString (dictR, "single_bool"); ERRORif (!item);
  fb.add_bool (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "single_num"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "num64"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "single_float"); ERRORif (!item);
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "single_string"); ERRORif (!item);
  fb.add_string (PyString_As_std_string (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "sibling1"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "sibling2"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "multi1"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "multi2"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "multi3"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "multi4"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "enum_field"); ERRORif (!item);
  fb.add_evalue (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "iface1"); ERRORif (!item);
  fb.add_object (PyAttr_As_uint64 (item, "__aida_pyobject__")); ERRORifpy();
  item = PyDict_GetItemString (dictR, "iface2"); ERRORif (!item);
  fb.add_object (PyAttr_As_uint64 (item, "__aida_pyobject__")); ERRORifpy();
  item = PyDict_GetItemString (dictR, "iface3"); ERRORif (!item);
  fb.add_object (PyAttr_As_uint64 (item, "__aida_pyobject__")); ERRORifpy();
  item = PyDict_GetItemString (dictR, "any1"); ERRORif (!item);
  { Rapicorn::Aida::Any tmpany;
    __AIDA_pyconvert__pyany_to_any (tmpany, item); ERRORifpy();
    fb.add_any (tmpany); }
  item = PyDict_GetItemString (dictR, "any2"); ERRORif (!item);
  { Rapicorn::Aida::Any tmpany;
    __AIDA_pyconvert__pyany_to_any (tmpany, item); ERRORifpy();
    fb.add_any (tmpany); }
  item = PyDict_GetItemString (dictR, "any3"); ERRORif (!item);
  { Rapicorn::Aida::Any tmpany;
    __AIDA_pyconvert__pyany_to_any (tmpany, item); ERRORifpy();
    fb.add_any (tmpany); }
  success = true;
 error:
  Py_XDECREF (dictR);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyXFooRecord_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *pytypeR = NULL, *pyinstR = NULL, *dictR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_rec());
  if (fbr.remaining() != 18) ERRORpy ("Aida: marshalling error: invalid record length");
  pytypeR = PyObject_GetAttrString (__AIDA_PYMODULE__OBJECT, "__AIDA_BaseRecord__"); AIDA_ASSERT (pytypeR != NULL);
  pyinstR = PyObject_CallObject (pytypeR, NULL); ERRORif (!pyinstR);
  dictR = PyObject_GetAttrString (pyinstR, "__dict__"); ERRORif (!dictR);
  pyfoR = PyLong_FromLongLong (fbr.pop_bool()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "single_bool", &pyfoR) < 0) goto error;
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "single_num", &pyfoR) < 0) goto error;
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "num64", &pyfoR) < 0) goto error;
  pyfoR = PyFloat_FromDouble (fbr.pop_double()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "single_float", &pyfoR) < 0) goto error;
  pyfoR = PyString_From_std_string (fbr.pop_string()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "single_string", &pyfoR) < 0) goto error;
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "sibling1", &pyfoR) < 0) goto error;
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "sibling2", &pyfoR) < 0) goto error;
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "multi1", &pyfoR) < 0) goto error;
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "multi2", &pyfoR) < 0) goto error;
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "multi3", &pyfoR) < 0) goto error;
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "multi4", &pyfoR) < 0) goto error;
  pyfoR = __AIDA_pyfactory__create_enum ("MandatoryNamespace.ExtensiveEnum", fbr.pop_evalue()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "enum_field", &pyfoR) < 0) goto error;
  pyfoR = __AIDA_pyfactory__create_from_orbid (fbr.pop_object()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "iface1", &pyfoR) < 0) goto error;
  pyfoR = __AIDA_pyfactory__create_from_orbid (fbr.pop_object()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "iface2", &pyfoR) < 0) goto error;
  pyfoR = __AIDA_pyfactory__create_from_orbid (fbr.pop_object()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "iface3", &pyfoR) < 0) goto error;
  pyfoR = __AIDA_pyconvert__pyany_from_any (fbr.pop_any()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "any1", &pyfoR) < 0) goto error;
  pyfoR = __AIDA_pyconvert__pyany_from_any (fbr.pop_any()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "any2", &pyfoR) < 0) goto error;
  pyfoR = __AIDA_pyconvert__pyany_from_any (fbr.pop_any()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "any3", &pyfoR) < 0) goto error;
  pyret = pyinstR;
 error:
  Py_XDECREF (pytypeR);
  Py_XDECREF (pyfoR);
  Py_XDECREF (dictR);
  if (pyret != pyinstR)
    Py_XDECREF (pyinstR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyXFooSequence_proto_add (PyObject *pyinput, Rapicorn::Aida::FieldBuffer &dst)
{
  PyObject *pyseq = PySequence_Fast (pyinput, "expected a sequence"); if (!pyseq) return false;
  const ssize_t len = PySequence_Fast_GET_SIZE (pyseq); if (len < 0) return false;
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  bool success = false;
  for (ssize_t k = 0; k < len; k++) {
    PyObject *item = PySequence_Fast_GET_ITEM (pyseq, k);
    fb.add_bool (PyIntLong_AsLongLong (item)); ERRORifpy();
  }
  success = true;
 error:
  Py_XDECREF (pyseq);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyXFooSequence_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *listR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  listR = PyList_New (len); if (!listR) GOTO_ERROR();
  for (size_t k = 0; k < len; k++) {
    pyfoR = PyLong_FromLongLong (fbr.pop_bool()); ERRORifpy ();
    PyList_SET_ITEM (listR, k, pyfoR), pyfoR = NULL;
  }
  pyret = listR;
 error:
  Py_XDECREF (pyfoR);
  if (pyret != listR)
    Py_XDECREF (listR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyIntSequence_proto_add (PyObject *pyinput, Rapicorn::Aida::FieldBuffer &dst)
{
  PyObject *pyseq = PySequence_Fast (pyinput, "expected a sequence"); if (!pyseq) return false;
  const ssize_t len = PySequence_Fast_GET_SIZE (pyseq); if (len < 0) return false;
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  bool success = false;
  for (ssize_t k = 0; k < len; k++) {
    PyObject *item = PySequence_Fast_GET_ITEM (pyseq, k);
    fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  }
  success = true;
 error:
  Py_XDECREF (pyseq);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyIntSequence_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *listR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  listR = PyList_New (len); if (!listR) GOTO_ERROR();
  for (size_t k = 0; k < len; k++) {
    pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
    PyList_SET_ITEM (listR, k, pyfoR), pyfoR = NULL;
  }
  pyret = listR;
 error:
  Py_XDECREF (pyfoR);
  if (pyret != listR)
    Py_XDECREF (listR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyFloatSequence_proto_add (PyObject *pyinput, Rapicorn::Aida::FieldBuffer &dst)
{
  PyObject *pyseq = PySequence_Fast (pyinput, "expected a sequence"); if (!pyseq) return false;
  const ssize_t len = PySequence_Fast_GET_SIZE (pyseq); if (len < 0) return false;
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  bool success = false;
  for (ssize_t k = 0; k < len; k++) {
    PyObject *item = PySequence_Fast_GET_ITEM (pyseq, k);
    fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  }
  success = true;
 error:
  Py_XDECREF (pyseq);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyFloatSequence_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *listR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  listR = PyList_New (len); if (!listR) GOTO_ERROR();
  for (size_t k = 0; k < len; k++) {
    pyfoR = PyFloat_FromDouble (fbr.pop_double()); ERRORifpy();
    PyList_SET_ITEM (listR, k, pyfoR), pyfoR = NULL;
  }
  pyret = listR;
 error:
  Py_XDECREF (pyfoR);
  if (pyret != listR)
    Py_XDECREF (listR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyStringSequence_proto_add (PyObject *pyinput, Rapicorn::Aida::FieldBuffer &dst)
{
  PyObject *pyseq = PySequence_Fast (pyinput, "expected a sequence"); if (!pyseq) return false;
  const ssize_t len = PySequence_Fast_GET_SIZE (pyseq); if (len < 0) return false;
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  bool success = false;
  for (ssize_t k = 0; k < len; k++) {
    PyObject *item = PySequence_Fast_GET_ITEM (pyseq, k);
    fb.add_string (PyString_As_std_string (item)); ERRORifpy();
  }
  success = true;
 error:
  Py_XDECREF (pyseq);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyStringSequence_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *listR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  listR = PyList_New (len); if (!listR) GOTO_ERROR();
  for (size_t k = 0; k < len; k++) {
    pyfoR = PyString_From_std_string (fbr.pop_string()); ERRORifpy();
    PyList_SET_ITEM (listR, k, pyfoR), pyfoR = NULL;
  }
  pyret = listR;
 error:
  Py_XDECREF (pyfoR);
  if (pyret != listR)
    Py_XDECREF (listR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyExtensiveEnumSequence_proto_add (PyObject *pyinput, Rapicorn::Aida::FieldBuffer &dst)
{
  PyObject *pyseq = PySequence_Fast (pyinput, "expected a sequence"); if (!pyseq) return false;
  const ssize_t len = PySequence_Fast_GET_SIZE (pyseq); if (len < 0) return false;
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  bool success = false;
  for (ssize_t k = 0; k < len; k++) {
    PyObject *item = PySequence_Fast_GET_ITEM (pyseq, k);
    fb.add_evalue (PyIntLong_AsLongLong (item)); ERRORifpy();
  }
  success = true;
 error:
  Py_XDECREF (pyseq);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyExtensiveEnumSequence_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *listR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  listR = PyList_New (len); if (!listR) GOTO_ERROR();
  for (size_t k = 0; k < len; k++) {
    pyfoR = __AIDA_pyfactory__create_enum ("MandatoryNamespace.ExtensiveEnum", fbr.pop_evalue()); ERRORifpy();
    PyList_SET_ITEM (listR, k, pyfoR), pyfoR = NULL;
  }
  pyret = listR;
 error:
  Py_XDECREF (pyfoR);
  if (pyret != listR)
    Py_XDECREF (listR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyRecordSequence_proto_add (PyObject *pyinput, Rapicorn::Aida::FieldBuffer &dst)
{
  PyObject *pyseq = PySequence_Fast (pyinput, "expected a sequence"); if (!pyseq) return false;
  const ssize_t len = PySequence_Fast_GET_SIZE (pyseq); if (len < 0) return false;
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  bool success = false;
  for (ssize_t k = 0; k < len; k++) {
    PyObject *item = PySequence_Fast_GET_ITEM (pyseq, k);
    if (!aida_pyXFooRecord_proto_add (item, fb)) goto error;
  }
  success = true;
 error:
  Py_XDECREF (pyseq);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyRecordSequence_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *listR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  listR = PyList_New (len); if (!listR) GOTO_ERROR();
  for (size_t k = 0; k < len; k++) {
    pyfoR = aida_pyXFooRecord_proto_pop (fbr); ERRORif (!pyfoR);
    PyList_SET_ITEM (listR, k, pyfoR), pyfoR = NULL;
  }
  pyret = listR;
 error:
  Py_XDECREF (pyfoR);
  if (pyret != listR)
    Py_XDECREF (listR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pySequenceSequence_proto_add (PyObject *pyinput, Rapicorn::Aida::FieldBuffer &dst)
{
  PyObject *pyseq = PySequence_Fast (pyinput, "expected a sequence"); if (!pyseq) return false;
  const ssize_t len = PySequence_Fast_GET_SIZE (pyseq); if (len < 0) return false;
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  bool success = false;
  for (ssize_t k = 0; k < len; k++) {
    PyObject *item = PySequence_Fast_GET_ITEM (pyseq, k);
    if (!aida_pyIntSequence_proto_add (item, fb)) goto error;
  }
  success = true;
 error:
  Py_XDECREF (pyseq);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pySequenceSequence_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *listR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  listR = PyList_New (len); if (!listR) GOTO_ERROR();
  for (size_t k = 0; k < len; k++) {
    pyfoR = aida_pyIntSequence_proto_pop (fbr); ERRORif (!pyfoR);
    PyList_SET_ITEM (listR, k, pyfoR), pyfoR = NULL;
  }
  pyret = listR;
 error:
  Py_XDECREF (pyfoR);
  if (pyret != listR)
    Py_XDECREF (listR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyInterfaceSequence_proto_add (PyObject *pyinput, Rapicorn::Aida::FieldBuffer &dst)
{
  PyObject *pyseq = PySequence_Fast (pyinput, "expected a sequence"); if (!pyseq) return false;
  const ssize_t len = PySequence_Fast_GET_SIZE (pyseq); if (len < 0) return false;
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  bool success = false;
  for (ssize_t k = 0; k < len; k++) {
    PyObject *item = PySequence_Fast_GET_ITEM (pyseq, k);
    fb.add_object (PyAttr_As_uint64 (item, "__aida_pyobject__")); ERRORifpy();
  }
  success = true;
 error:
  Py_XDECREF (pyseq);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyInterfaceSequence_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *listR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  listR = PyList_New (len); if (!listR) GOTO_ERROR();
  for (size_t k = 0; k < len; k++) {
    pyfoR = __AIDA_pyfactory__create_from_orbid (fbr.pop_object()); ERRORifpy();
    PyList_SET_ITEM (listR, k, pyfoR), pyfoR = NULL;
  }
  pyret = listR;
 error:
  Py_XDECREF (pyfoR);
  if (pyret != listR)
    Py_XDECREF (listR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyAnySequence_proto_add (PyObject *pyinput, Rapicorn::Aida::FieldBuffer &dst)
{
  PyObject *pyseq = PySequence_Fast (pyinput, "expected a sequence"); if (!pyseq) return false;
  const ssize_t len = PySequence_Fast_GET_SIZE (pyseq); if (len < 0) return false;
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  bool success = false;
  for (ssize_t k = 0; k < len; k++) {
    PyObject *item = PySequence_Fast_GET_ITEM (pyseq, k);
    { Rapicorn::Aida::Any tmpany;
      __AIDA_pyconvert__pyany_to_any (tmpany, item); ERRORifpy();
      fb.add_any (tmpany); }
  }
  success = true;
 error:
  Py_XDECREF (pyseq);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyAnySequence_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *listR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  listR = PyList_New (len); if (!listR) GOTO_ERROR();
  for (size_t k = 0; k < len; k++) {
    pyfoR = __AIDA_pyconvert__pyany_from_any (fbr.pop_any()); ERRORifpy();
    PyList_SET_ITEM (listR, k, pyfoR), pyfoR = NULL;
  }
  pyret = listR;
 error:
  Py_XDECREF (pyfoR);
  if (pyret != listR)
    Py_XDECREF (listR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyNestedTypesRec_proto_add (PyObject *pyrec, Rapicorn::Aida::FieldBuffer &dst)
{
  Rapicorn::Aida::FieldBuffer &fb = dst.add_rec (2);
  bool success = false;
  PyObject *dictR = NULL, *item = NULL;
  dictR = PyObject_GetAttrString (pyrec, "__dict__"); ERRORif (!dictR);
  item = PyDict_GetItemString (dictR, "rec"); ERRORif (!item);
  if (!aida_pyXFooRecord_proto_add (item, fb)) goto error;
  item = PyDict_GetItemString (dictR, "seq"); ERRORif (!item);
  if (!aida_pyXFooSequence_proto_add (item, fb)) goto error;
  success = true;
 error:
  Py_XDECREF (dictR);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyNestedTypesRec_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *pytypeR = NULL, *pyinstR = NULL, *dictR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_rec());
  if (fbr.remaining() != 2) ERRORpy ("Aida: marshalling error: invalid record length");
  pytypeR = PyObject_GetAttrString (__AIDA_PYMODULE__OBJECT, "__AIDA_BaseRecord__"); AIDA_ASSERT (pytypeR != NULL);
  pyinstR = PyObject_CallObject (pytypeR, NULL); ERRORif (!pyinstR);
  dictR = PyObject_GetAttrString (pyinstR, "__dict__"); ERRORif (!dictR);
  pyfoR = aida_pyXFooRecord_proto_pop (fbr); ERRORif (!pyfoR);
  if (PyDict_Take_Item (dictR, "rec", &pyfoR) < 0) goto error;
  pyfoR = aida_pyXFooSequence_proto_pop (fbr); ERRORif (!pyfoR);
  if (PyDict_Take_Item (dictR, "seq", &pyfoR) < 0) goto error;
  pyret = pyinstR;
 error:
  Py_XDECREF (pytypeR);
  Py_XDECREF (pyfoR);
  Py_XDECREF (dictR);
  if (pyret != pyinstR)
    Py_XDECREF (pyinstR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyNestedTypesSeq_proto_add (PyObject *pyinput, Rapicorn::Aida::FieldBuffer &dst)
{
  PyObject *pyseq = PySequence_Fast (pyinput, "expected a sequence"); if (!pyseq) return false;
  const ssize_t len = PySequence_Fast_GET_SIZE (pyseq); if (len < 0) return false;
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  bool success = false;
  for (ssize_t k = 0; k < len; k++) {
    PyObject *item = PySequence_Fast_GET_ITEM (pyseq, k);
    if (!aida_pyNestedTypesRec_proto_add (item, fb)) goto error;
  }
  success = true;
 error:
  Py_XDECREF (pyseq);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyNestedTypesSeq_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *listR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  listR = PyList_New (len); if (!listR) GOTO_ERROR();
  for (size_t k = 0; k < len; k++) {
    pyfoR = aida_pyNestedTypesRec_proto_pop (fbr); ERRORif (!pyfoR);
    PyList_SET_ITEM (listR, k, pyfoR), pyfoR = NULL;
  }
  pyret = listR;
 error:
  Py_XDECREF (pyfoR);
  if (pyret != listR)
    Py_XDECREF (listR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyNewRecord_proto_add (PyObject *pyrec, Rapicorn::Aida::FieldBuffer &dst)
{
  Rapicorn::Aida::FieldBuffer &fb = dst.add_rec (4);
  bool success = false;
  PyObject *dictR = NULL, *item = NULL;
  dictR = PyObject_GetAttrString (pyrec, "__dict__"); ERRORif (!dictR);
  item = PyDict_GetItemString (dictR, "i"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "enum1"); ERRORif (!item);
  fb.add_evalue (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "xfs"); ERRORif (!item);
  if (!aida_pyXFooSequence_proto_add (item, fb)) goto error;
  item = PyDict_GetItemString (dictR, "ntr"); ERRORif (!item);
  if (!aida_pyNestedTypesRec_proto_add (item, fb)) goto error;
  success = true;
 error:
  Py_XDECREF (dictR);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyNewRecord_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *pytypeR = NULL, *pyinstR = NULL, *dictR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_rec());
  if (fbr.remaining() != 4) ERRORpy ("Aida: marshalling error: invalid record length");
  pytypeR = PyObject_GetAttrString (__AIDA_PYMODULE__OBJECT, "__AIDA_BaseRecord__"); AIDA_ASSERT (pytypeR != NULL);
  pyinstR = PyObject_CallObject (pytypeR, NULL); ERRORif (!pyinstR);
  dictR = PyObject_GetAttrString (pyinstR, "__dict__"); ERRORif (!dictR);
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "i", &pyfoR) < 0) goto error;
  pyfoR = __AIDA_pyfactory__create_enum ("MandatoryNamespace.Enum1", fbr.pop_evalue()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "enum1", &pyfoR) < 0) goto error;
  pyfoR = aida_pyXFooSequence_proto_pop (fbr); ERRORif (!pyfoR);
  if (PyDict_Take_Item (dictR, "xfs", &pyfoR) < 0) goto error;
  pyfoR = aida_pyNestedTypesRec_proto_pop (fbr); ERRORif (!pyfoR);
  if (PyDict_Take_Item (dictR, "ntr", &pyfoR) < 0) goto error;
  pyret = pyinstR;
 error:
  Py_XDECREF (pytypeR);
  Py_XDECREF (pyfoR);
  Py_XDECREF (dictR);
  if (pyret != pyinstR)
    Py_XDECREF (pyinstR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyInnerRecord_proto_add (PyObject *pyrec, Rapicorn::Aida::FieldBuffer &dst)
{
  Rapicorn::Aida::FieldBuffer &fb = dst.add_rec (3);
  bool success = false;
  PyObject *dictR = NULL, *item = NULL;
  dictR = PyObject_GetAttrString (pyrec, "__dict__"); ERRORif (!dictR);
  item = PyDict_GetItemString (dictR, "x"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "y"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "rec"); ERRORif (!item);
  if (!aida_pyNewRecord_proto_add (item, fb)) goto error;
  success = true;
 error:
  Py_XDECREF (dictR);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyInnerRecord_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *pytypeR = NULL, *pyinstR = NULL, *dictR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_rec());
  if (fbr.remaining() != 3) ERRORpy ("Aida: marshalling error: invalid record length");
  pytypeR = PyObject_GetAttrString (__AIDA_PYMODULE__OBJECT, "__AIDA_BaseRecord__"); AIDA_ASSERT (pytypeR != NULL);
  pyinstR = PyObject_CallObject (pytypeR, NULL); ERRORif (!pyinstR);
  dictR = PyObject_GetAttrString (pyinstR, "__dict__"); ERRORif (!dictR);
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "x", &pyfoR) < 0) goto error;
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "y", &pyfoR) < 0) goto error;
  pyfoR = aida_pyNewRecord_proto_pop (fbr); ERRORif (!pyfoR);
  if (PyDict_Take_Item (dictR, "rec", &pyfoR) < 0) goto error;
  pyret = pyinstR;
 error:
  Py_XDECREF (pytypeR);
  Py_XDECREF (pyfoR);
  Py_XDECREF (dictR);
  if (pyret != pyinstR)
    Py_XDECREF (pyinstR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyRefer2Inner_proto_add (PyObject *pyrec, Rapicorn::Aida::FieldBuffer &dst)
{
  Rapicorn::Aida::FieldBuffer &fb = dst.add_rec (1);
  bool success = false;
  PyObject *dictR = NULL, *item = NULL;
  dictR = PyObject_GetAttrString (pyrec, "__dict__"); ERRORif (!dictR);
  item = PyDict_GetItemString (dictR, "r"); ERRORif (!item);
  if (!aida_pyInnerRecord_proto_add (item, fb)) goto error;
  success = true;
 error:
  Py_XDECREF (dictR);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyRefer2Inner_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *pytypeR = NULL, *pyinstR = NULL, *dictR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_rec());
  if (fbr.remaining() != 1) ERRORpy ("Aida: marshalling error: invalid record length");
  pytypeR = PyObject_GetAttrString (__AIDA_PYMODULE__OBJECT, "__AIDA_BaseRecord__"); AIDA_ASSERT (pytypeR != NULL);
  pyinstR = PyObject_CallObject (pytypeR, NULL); ERRORif (!pyinstR);
  dictR = PyObject_GetAttrString (pyinstR, "__dict__"); ERRORif (!dictR);
  pyfoR = aida_pyInnerRecord_proto_pop (fbr); ERRORif (!pyfoR);
  if (PyDict_Take_Item (dictR, "r", &pyfoR) < 0) goto error;
  pyret = pyinstR;
 error:
  Py_XDECREF (pytypeR);
  Py_XDECREF (pyfoR);
  Py_XDECREF (dictR);
  if (pyret != pyinstR)
    Py_XDECREF (pyinstR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pySomeRecord_proto_add (PyObject *pyrec, Rapicorn::Aida::FieldBuffer &dst)
{
  Rapicorn::Aida::FieldBuffer &fb = dst.add_rec (4);
  bool success = false;
  PyObject *dictR = NULL, *item = NULL;
  dictR = PyObject_GetAttrString (pyrec, "__dict__"); ERRORif (!dictR);
  item = PyDict_GetItemString (dictR, "r1"); ERRORif (!item);
  if (!aida_pyNewRecord_proto_add (item, fb)) goto error;
  item = PyDict_GetItemString (dictR, "r2"); ERRORif (!item);
  if (!aida_pyNewRecord_proto_add (item, fb)) goto error;
  item = PyDict_GetItemString (dictR, "r3"); ERRORif (!item);
  if (!aida_pyInnerRecord_proto_add (item, fb)) goto error;
  item = PyDict_GetItemString (dictR, "r4"); ERRORif (!item);
  if (!aida_pyInnerRecord_proto_add (item, fb)) goto error;
  success = true;
 error:
  Py_XDECREF (dictR);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pySomeRecord_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *pytypeR = NULL, *pyinstR = NULL, *dictR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_rec());
  if (fbr.remaining() != 4) ERRORpy ("Aida: marshalling error: invalid record length");
  pytypeR = PyObject_GetAttrString (__AIDA_PYMODULE__OBJECT, "__AIDA_BaseRecord__"); AIDA_ASSERT (pytypeR != NULL);
  pyinstR = PyObject_CallObject (pytypeR, NULL); ERRORif (!pyinstR);
  dictR = PyObject_GetAttrString (pyinstR, "__dict__"); ERRORif (!dictR);
  pyfoR = aida_pyNewRecord_proto_pop (fbr); ERRORif (!pyfoR);
  if (PyDict_Take_Item (dictR, "r1", &pyfoR) < 0) goto error;
  pyfoR = aida_pyNewRecord_proto_pop (fbr); ERRORif (!pyfoR);
  if (PyDict_Take_Item (dictR, "r2", &pyfoR) < 0) goto error;
  pyfoR = aida_pyInnerRecord_proto_pop (fbr); ERRORif (!pyfoR);
  if (PyDict_Take_Item (dictR, "r3", &pyfoR) < 0) goto error;
  pyfoR = aida_pyInnerRecord_proto_pop (fbr); ERRORif (!pyfoR);
  if (PyDict_Take_Item (dictR, "r4", &pyfoR) < 0) goto error;
  pyret = pyinstR;
 error:
  Py_XDECREF (pytypeR);
  Py_XDECREF (pyfoR);
  Py_XDECREF (dictR);
  if (pyret != pyinstR)
    Py_XDECREF (pyinstR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyQuickRecord_proto_add (PyObject *pyrec, Rapicorn::Aida::FieldBuffer &dst)
{
  Rapicorn::Aida::FieldBuffer &fb = dst.add_rec (2);
  bool success = false;
  PyObject *dictR = NULL, *item = NULL;
  dictR = PyObject_GetAttrString (pyrec, "__dict__"); ERRORif (!dictR);
  item = PyDict_GetItemString (dictR, "int1"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "int2"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  success = true;
 error:
  Py_XDECREF (dictR);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyQuickRecord_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *pytypeR = NULL, *pyinstR = NULL, *dictR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_rec());
  if (fbr.remaining() != 2) ERRORpy ("Aida: marshalling error: invalid record length");
  pytypeR = PyObject_GetAttrString (__AIDA_PYMODULE__OBJECT, "__AIDA_BaseRecord__"); AIDA_ASSERT (pytypeR != NULL);
  pyinstR = PyObject_CallObject (pytypeR, NULL); ERRORif (!pyinstR);
  dictR = PyObject_GetAttrString (pyinstR, "__dict__"); ERRORif (!dictR);
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "int1", &pyfoR) < 0) goto error;
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "int2", &pyfoR) < 0) goto error;
  pyret = pyinstR;
 error:
  Py_XDECREF (pytypeR);
  Py_XDECREF (pyfoR);
  Py_XDECREF (dictR);
  if (pyret != pyinstR)
    Py_XDECREF (pyinstR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyQuickSequence_proto_add (PyObject *pyinput, Rapicorn::Aida::FieldBuffer &dst)
{
  PyObject *pyseq = PySequence_Fast (pyinput, "expected a sequence"); if (!pyseq) return false;
  const ssize_t len = PySequence_Fast_GET_SIZE (pyseq); if (len < 0) return false;
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  bool success = false;
  for (ssize_t k = 0; k < len; k++) {
    PyObject *item = PySequence_Fast_GET_ITEM (pyseq, k);
    fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  }
  success = true;
 error:
  Py_XDECREF (pyseq);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyQuickSequence_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *listR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  listR = PyList_New (len); if (!listR) GOTO_ERROR();
  for (size_t k = 0; k < len; k++) {
    pyfoR = PyFloat_FromDouble (fbr.pop_double()); ERRORifpy();
    PyList_SET_ITEM (listR, k, pyfoR), pyfoR = NULL;
  }
  pyret = listR;
 error:
  Py_XDECREF (pyfoR);
  if (pyret != listR)
    Py_XDECREF (listR);
  return pyret;
}

static RAPICORN_UNUSED bool
aida_pyRecordForGroups_proto_add (PyObject *pyrec, Rapicorn::Aida::FieldBuffer &dst)
{
  Rapicorn::Aida::FieldBuffer &fb = dst.add_rec (5);
  bool success = false;
  PyObject *dictR = NULL, *item = NULL;
  dictR = PyObject_GetAttrString (pyrec, "__dict__"); ERRORif (!dictR);
  item = PyDict_GetItemString (dictR, "i"); ERRORif (!item);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "ratio"); ERRORif (!item);
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "ordinary_bool"); ERRORif (!item);
  fb.add_bool (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "threshold1"); ERRORif (!item);
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  item = PyDict_GetItemString (dictR, "threshold2"); ERRORif (!item);
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  success = true;
 error:
  Py_XDECREF (dictR);
  return success;
}
static RAPICORN_UNUSED PyObject*
aida_pyRecordForGroups_proto_pop (Rapicorn::Aida::FieldReader &src)
{
  PyObject *pytypeR = NULL, *pyinstR = NULL, *dictR = NULL, *pyfoR = NULL, *pyret = NULL;
  Rapicorn::Aida::FieldReader fbr (src.pop_rec());
  if (fbr.remaining() != 5) ERRORpy ("Aida: marshalling error: invalid record length");
  pytypeR = PyObject_GetAttrString (__AIDA_PYMODULE__OBJECT, "__AIDA_BaseRecord__"); AIDA_ASSERT (pytypeR != NULL);
  pyinstR = PyObject_CallObject (pytypeR, NULL); ERRORif (!pyinstR);
  dictR = PyObject_GetAttrString (pyinstR, "__dict__"); ERRORif (!dictR);
  pyfoR = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "i", &pyfoR) < 0) goto error;
  pyfoR = PyFloat_FromDouble (fbr.pop_double()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "ratio", &pyfoR) < 0) goto error;
  pyfoR = PyLong_FromLongLong (fbr.pop_bool()); ERRORifpy ();
  if (PyDict_Take_Item (dictR, "ordinary_bool", &pyfoR) < 0) goto error;
  pyfoR = PyFloat_FromDouble (fbr.pop_double()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "threshold1", &pyfoR) < 0) goto error;
  pyfoR = PyFloat_FromDouble (fbr.pop_double()); ERRORifpy();
  if (PyDict_Take_Item (dictR, "threshold2", &pyfoR) < 0) goto error;
  pyret = pyinstR;
 error:
  Py_XDECREF (pytypeR);
  Py_XDECREF (pyfoR);
  Py_XDECREF (dictR);
  if (pyret != pyinstR)
    Py_XDECREF (pyinstR);
  return pyret;
}

static PyObject*
__AIDA_pycall__c3f858f5171056cb394e47a2bcd63e16__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 0), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 0) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xc3f858f5171056cbULL, 0x394e47a2bcd63e16ULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__d0dd4c08ba5022c0b1af31ca1ec7037a__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 0), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 0) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xd0dd4c08ba5022c0ULL, 0xb1af31ca1ec7037aULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyFloat_FromDouble (frr.pop_double()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__e4e890540b4c0579e14a7ffaa82f1c4f__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xe4e890540b4c0579ULL, 0xe14a7ffaa82f1c4fULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // n
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyFloat_FromDouble (frr.pop_double()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__9cfaa316ccbb6ea06cc5207c5520e081__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x9cfaa316ccbb6ea0ULL, 0x6cc5207c5520e081ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // n
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyFloat_FromDouble (frr.pop_double()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__64511c410b16c27419b47eb22b4cd4d4__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x64511c410b16c274ULL, 0x19b47eb22b4cd4d4ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // n
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 2); // r
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyFloat_FromDouble (frr.pop_double()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__2089150ae3f7ad80e6154471cb4560e0__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x2089150ae3f7ad80ULL, 0xe6154471cb4560e0ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // n
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 2); // r
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyFloat_FromDouble (frr.pop_double()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__349f073a5bad36fdf7a10ae13b8e391b__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 6), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 6) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x349f073a5bad36fdULL, 0xf7a10ae13b8e391bULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // b
  fb.add_bool (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 2); // n
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 3); // r
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 4); // i
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 5); // s
  fb.add_string (PyString_As_std_string (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 6); // y
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyFloat_FromDouble (frr.pop_double()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__4b479b2f4e3ba551b7c407eee57eb21a__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x4b479b2f4e3ba551ULL, 0xb7c407eee57eb21aULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // ba1
  fb.add_object (PyAttr_As_uint64 (item, "__aida_pyobject__")); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 2); // ba2
  fb.add_object (PyAttr_As_uint64 (item, "__aida_pyobject__")); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyFloat_FromDouble (frr.pop_double()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__dbb304ad4df15873ca276abf2bb1603c__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 0), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 0) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xdbb304ad4df15873ULL, 0xca276abf2bb1603cULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__b8bc20394724087abc7b1e7d30aeb178__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 0), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 0) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xb8bc20394724087aULL, 0xbc7b1e7d30aeb178ULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyString_From_std_string (frr.pop_string()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__3432c3bb41bc72a0533bc22135f973bf__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0x3432c3bb41bc72a0ULL, 0x533bc22135f973bfULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // command
  fb.add_string (PyString_As_std_string (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__UIWidgetArea__void_signal (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__0774aa0ffbdf5f023f1b5247dca90c86__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x0774aa0ffbdf5f02ULL, 0x3f1b5247dca90c86ULL, oid, __AIDA_pyemit1__UIWidgetArea__void_signal, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__UIWidgetArea__sample_signal (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 2;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  item = __AIDA_pyfactory__create_from_orbid (fbr.pop_object()); ERRORifpy();
  PyTuple_SET_ITEM (tuple, 0, item);
  item = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  PyTuple_SET_ITEM (tuple, 1, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0x219d8339499d690eULL, 0x08bca1e9a82f86b0ULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_double (0);
    goto error;
  } else {
    (*rb).add_double (PyFloat_AsDouble (result)); ERROR_callable_ifpy (callable);
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__219d8339499d690e08bca1e9a82f86b0__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x219d8339499d690eULL, 0x08bca1e9a82f86b0ULL, oid, __AIDA_pyemit2__UIWidgetArea__sample_signal, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static PyObject*
__AIDA_pygetter__f67db704b9d460d6d4950feab697e61e__ (PyObject *pyself, PyObject *pyargs) // UIWidgetArea.dummy
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xf67db704b9d460d6ULL, 0xd4950feab697e61eULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyLong_FromLongLong (frr.pop_bool()); ERRORifpy ();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__7aaf2f96f30428293d0391e5b72e7ba5__ (PyObject *pyself, PyObject *pyargs) // UIWidgetArea.dummy
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0x7aaf2f96f3042829ULL, 0x3d0391e5b72e7ba5ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_bool (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__58ba68f6b64584c9a7d2686edb40f27a__ (PyObject *pyself, PyObject *pyargs) // UIWidgetArea.on_click
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x58ba68f6b64584c9ULL, 0xa7d2686edb40f27aULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyString_From_std_string (frr.pop_string()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__f0025ec0fa66e3e2880c10e8e6b57cfb__ (PyObject *pyself, PyObject *pyargs) // UIWidgetArea.on_click
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xf0025ec0fa66e3e2ULL, 0x880c10e8e6b57cfbULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_string (PyString_As_std_string (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__76ac7a704663d24623abac49621c6802__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0x76ac7a704663d246ULL, 0x23abac49621c6802ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // i
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__1addfccb0a3e01be314f2eb467d7a72b__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 0), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 0) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0x1addfccb0a3e01beULL, 0x314f2eb467d7a72bULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__55291a7348d1424232dac90dde65a764__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x55291a7348d14242ULL, 0x32dac90dde65a764ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // input
  fb.add_bool (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 2); // optval
  fb.add_bool (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyLong_FromLongLong (frr.pop_bool()); ERRORifpy ();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__dc38cf6855c54108328ddcdcec8f161e__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xdc38cf6855c54108ULL, 0x328ddcdcec8f161eULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // input
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 2); // optval
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyLong_FromLongLong (frr.pop_int64()); ERRORifpy ();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__678de8636167b6a1b27d37ca066b5335__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x678de8636167b6a1ULL, 0xb27d37ca066b5335ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // input
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 2); // optval
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyLong_FromLongLong (frr.pop_int64()); ERRORifpy ();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__eea6d5fb184699a3ce05c988a9bfd2d9__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xeea6d5fb184699a3ULL, 0xce05c988a9bfd2d9ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // input
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 2); // optval
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyFloat_FromDouble (frr.pop_double()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__646f80849d732dc572fd1ede45b153e3__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x646f80849d732dc5ULL, 0x72fd1ede45b153e3ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // input
  fb.add_string (PyString_As_std_string (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 2); // optval
  fb.add_string (PyString_As_std_string (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyString_From_std_string (frr.pop_string()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__ee3b0b1c6eb52bde13729d2db240b4f9__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xee3b0b1c6eb52bdeULL, 0x13729d2db240b4f9ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // input
  fb.add_evalue (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 2); // optval
  fb.add_evalue (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = __AIDA_pyfactory__create_enum ("InterfaceTests.QuickEnum", frr.pop_evalue()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__852c7f5942a87cce487dc78cd38240f6__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x852c7f5942a87cceULL, 0x487dc78cd38240f6ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // input
  if (!aida_pyQuickRecord_proto_add (item, fb)) goto error;
  item = PyTuple_GET_ITEM (pyargs, 2); // optval
  if (!aida_pyQuickRecord_proto_add (item, fb)) goto error;
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = aida_pyQuickRecord_proto_pop (frr); ERRORif (!pyfoR);
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__5534838e08bdc63dd852fd5abb88ab7d__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x5534838e08bdc63dULL, 0xd852fd5abb88ab7dULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // input
  if (!aida_pyQuickSequence_proto_add (item, fb)) goto error;
  item = PyTuple_GET_ITEM (pyargs, 2); // optval
  if (!aida_pyQuickSequence_proto_add (item, fb)) goto error;
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = aida_pyQuickSequence_proto_pop (frr); ERRORif (!pyfoR);
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__fe9af28dc9c5de7d418be0c0e085ea6d__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xfe9af28dc9c5de7dULL, 0x418be0c0e085ea6dULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // input
  fb.add_object (PyAttr_As_uint64 (item, "__aida_pyobject__")); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 2); // optval
  fb.add_object (PyAttr_As_uint64 (item, "__aida_pyobject__")); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = __AIDA_pyfactory__create_from_orbid (frr.pop_object()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__807e5dacf307a2772b65069e50e63c80__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x807e5dacf307a277ULL, 0x2b65069e50e63c80ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // input
  { Rapicorn::Aida::Any tmpany;
    __AIDA_pyconvert__pyany_to_any (tmpany, item); ERRORifpy();
    fb.add_any (tmpany); }
  item = PyTuple_GET_ITEM (pyargs, 2); // optval
  { Rapicorn::Aida::Any tmpany;
    __AIDA_pyconvert__pyany_to_any (tmpany, item); ERRORifpy();
    fb.add_any (tmpany); }
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = __AIDA_pyconvert__pyany_from_any (frr.pop_any()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__be67f4e0afeafd685cdf24c075b03215__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 2), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xbe67f4e0afeafd68ULL, 0x5cdf24c075b03215ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // input
  fb.add_object (PyAttr_As_uint64 (item, "__aida_pyobject__")); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 2); // iface0
  fb.add_object (PyAttr_As_uint64 (item, "__aida_pyobject__")); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = __AIDA_pyfactory__create_from_orbid (frr.pop_object()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__void_result (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__e2ae7c707a04333c420330b70d64eb5f__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0xe2ae7c707a04333cULL, 0x420330b70d64eb5fULL, oid, __AIDA_pyemit1__SignalTestInterface__void_result, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__SignalTestInterface__bool_result (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0x31529d809bd68e6bULL, 0xa11d55517d4325aeULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_bool (0);
    goto error;
  } else {
    (*rb).add_bool (PyIntLong_AsLongLong (result)); ERROR_callable_ifpy (callable);
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__31529d809bd68e6ba11d55517d4325ae__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x31529d809bd68e6bULL, 0xa11d55517d4325aeULL, oid, __AIDA_pyemit2__SignalTestInterface__bool_result, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__SignalTestInterface__int32_result (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0xac712d196d3466f3ULL, 0xeb06bf4f2b2a414cULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_int64 (0);
    goto error;
  } else {
    (*rb).add_int64 (PyIntLong_AsLongLong (result)); ERROR_callable_ifpy (callable);
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__ac712d196d3466f3eb06bf4f2b2a414c__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0xac712d196d3466f3ULL, 0xeb06bf4f2b2a414cULL, oid, __AIDA_pyemit2__SignalTestInterface__int32_result, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__SignalTestInterface__int64_result (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0x1439d37d87e2668bULL, 0x57ded621e6b0cde6ULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_int64 (0);
    goto error;
  } else {
    (*rb).add_int64 (PyIntLong_AsLongLong (result)); ERROR_callable_ifpy (callable);
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__1439d37d87e2668b57ded621e6b0cde6__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x1439d37d87e2668bULL, 0x57ded621e6b0cde6ULL, oid, __AIDA_pyemit2__SignalTestInterface__int64_result, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__SignalTestInterface__float64_result (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0x4c5a782eaa76edb0ULL, 0xb66fbaa524004fd9ULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_double (0);
    goto error;
  } else {
    (*rb).add_double (PyFloat_AsDouble (result)); ERROR_callable_ifpy (callable);
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__4c5a782eaa76edb0b66fbaa524004fd9__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x4c5a782eaa76edb0ULL, 0xb66fbaa524004fd9ULL, oid, __AIDA_pyemit2__SignalTestInterface__float64_result, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__SignalTestInterface__string_result (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0xbc5c00f41d7c710dULL, 0x368d920fb6c136e6ULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_string ("");
    goto error;
  } else {
    (*rb).add_string (PyString_As_std_string (result)); ERROR_callable_ifpy (callable);
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__bc5c00f41d7c710d368d920fb6c136e6__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0xbc5c00f41d7c710dULL, 0x368d920fb6c136e6ULL, oid, __AIDA_pyemit2__SignalTestInterface__string_result, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__SignalTestInterface__enum_result (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0x60702e53aca1b772ULL, 0xeac0d39852c951fbULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_evalue (0);
    goto error;
  } else {
    (*rb).add_evalue (PyIntLong_AsLongLong (result)); ERROR_callable_ifpy (callable);
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__60702e53aca1b772eac0d39852c951fb__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x60702e53aca1b772ULL, 0xeac0d39852c951fbULL, oid, __AIDA_pyemit2__SignalTestInterface__enum_result, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__SignalTestInterface__record_result (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0x755d247d6abfde87ULL, 0x093ff68bbb0f5257ULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_rec (0);
    goto error;
  } else {
    if (!aida_pyQuickRecord_proto_add (result, (*rb))) goto error;
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__755d247d6abfde87093ff68bbb0f5257__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x755d247d6abfde87ULL, 0x093ff68bbb0f5257ULL, oid, __AIDA_pyemit2__SignalTestInterface__record_result, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__SignalTestInterface__sequence_result (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0xb5c453295aa72207ULL, 0x7c0fa1c12417b139ULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_seq (0);
    goto error;
  } else {
    if (!aida_pyQuickSequence_proto_add (result, (*rb))) goto error;
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__b5c453295aa722077c0fa1c12417b139__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0xb5c453295aa72207ULL, 0x7c0fa1c12417b139ULL, oid, __AIDA_pyemit2__SignalTestInterface__sequence_result, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__SignalTestInterface__interface_result (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0xe8ef1fe5de31f95bULL, 0xc0e4bcc410120585ULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_object (NULL);
    goto error;
  } else {
    (*rb).add_object (PyAttr_As_uint64 (result, "__aida_pyobject__")); ERROR_callable_ifpy (callable);
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__e8ef1fe5de31f95bc0e4bcc410120585__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0xe8ef1fe5de31f95bULL, 0xc0e4bcc410120585ULL, oid, __AIDA_pyemit2__SignalTestInterface__interface_result, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__SignalTestInterface__any_result (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0x296163d4220985ceULL, 0x40daacab4a841093ULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_any (Rapicorn::Aida::Any());
    goto error;
  } else {
    { Rapicorn::Aida::Any tmpany;
    __AIDA_pyconvert__pyany_to_any (tmpany, result); ERROR_callable_ifpy (callable);
    (*rb).add_any (tmpany); }
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__296163d4220985ce40daacab4a841093__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x296163d4220985ceULL, 0x40daacab4a841093ULL, oid, __AIDA_pyemit2__SignalTestInterface__any_result, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__SignalTestInterface__self_result (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0x35828273200534f7ULL, 0x72873f1374d6093bULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_object (NULL);
    goto error;
  } else {
    (*rb).add_object (PyAttr_As_uint64 (result, "__aida_pyobject__")); ERROR_callable_ifpy (callable);
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__35828273200534f772873f1374d6093b__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x35828273200534f7ULL, 0x72873f1374d6093bULL, oid, __AIDA_pyemit2__SignalTestInterface__self_result, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__void_arg (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__e79b3592345942f66818e92df5df5bef__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0xe79b3592345942f6ULL, 0x6818e92df5df5befULL, oid, __AIDA_pyemit1__SignalTestInterface__void_arg, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__bool_arg (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 1;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  item = PyLong_FromLongLong (fbr.pop_bool()); ERRORifpy ();
  PyTuple_SET_ITEM (tuple, 0, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__495e3d2d698caad7f16b2f75ddaf3220__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x495e3d2d698caad7ULL, 0xf16b2f75ddaf3220ULL, oid, __AIDA_pyemit1__SignalTestInterface__bool_arg, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__int32_arg (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 1;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  item = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  PyTuple_SET_ITEM (tuple, 0, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__1d335377194859d1fa00c7fb47bc82e4__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x1d335377194859d1ULL, 0xfa00c7fb47bc82e4ULL, oid, __AIDA_pyemit1__SignalTestInterface__int32_arg, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__int64_arg (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 1;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  item = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  PyTuple_SET_ITEM (tuple, 0, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__52b8b36ec08458caeecdb452f6b51528__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x52b8b36ec08458caULL, 0xeecdb452f6b51528ULL, oid, __AIDA_pyemit1__SignalTestInterface__int64_arg, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__float64_arg (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 1;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  item = PyFloat_FromDouble (fbr.pop_double()); ERRORifpy();
  PyTuple_SET_ITEM (tuple, 0, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__dcacb20b2d942f30242d314085f3e44a__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0xdcacb20b2d942f30ULL, 0x242d314085f3e44aULL, oid, __AIDA_pyemit1__SignalTestInterface__float64_arg, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__string_arg (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 1;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  item = PyString_From_std_string (fbr.pop_string()); ERRORifpy();
  PyTuple_SET_ITEM (tuple, 0, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__9bb22c59672e3921981c8364b2197db9__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x9bb22c59672e3921ULL, 0x981c8364b2197db9ULL, oid, __AIDA_pyemit1__SignalTestInterface__string_arg, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__enum_arg (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 1;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  item = __AIDA_pyfactory__create_enum ("InterfaceTests.QuickEnum", fbr.pop_evalue()); ERRORifpy();
  PyTuple_SET_ITEM (tuple, 0, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__62459d25ac74ebedd598edad744f61b7__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x62459d25ac74ebedULL, 0xd598edad744f61b7ULL, oid, __AIDA_pyemit1__SignalTestInterface__enum_arg, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__record_arg (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 1;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  item = aida_pyQuickRecord_proto_pop (fbr); ERRORif (!item);
  PyTuple_SET_ITEM (tuple, 0, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__e4c732769519ca6a8cf6e34972e875aa__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0xe4c732769519ca6aULL, 0x8cf6e34972e875aaULL, oid, __AIDA_pyemit1__SignalTestInterface__record_arg, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__sequence_arg (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 1;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  item = aida_pyQuickSequence_proto_pop (fbr); ERRORif (!item);
  PyTuple_SET_ITEM (tuple, 0, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__eca8cf0dd80dee4a1bb3845a0704c774__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0xeca8cf0dd80dee4aULL, 0x1bb3845a0704c774ULL, oid, __AIDA_pyemit1__SignalTestInterface__sequence_arg, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__interface_arg (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 1;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  item = __AIDA_pyfactory__create_from_orbid (fbr.pop_object()); ERRORifpy();
  PyTuple_SET_ITEM (tuple, 0, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__c2562bdab457affd189f1ba486f30579__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0xc2562bdab457affdULL, 0x189f1ba486f30579ULL, oid, __AIDA_pyemit1__SignalTestInterface__interface_arg, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__any_arg (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 1;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  item = __AIDA_pyconvert__pyany_from_any (fbr.pop_any()); ERRORifpy();
  PyTuple_SET_ITEM (tuple, 0, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__445abac8fb3999b7422ee36946f0b021__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x445abac8fb3999b7ULL, 0x422ee36946f0b021ULL, oid, __AIDA_pyemit1__SignalTestInterface__any_arg, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__SignalTestInterface__self_args (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 1;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  item = __AIDA_pyfactory__create_from_orbid (fbr.pop_object()); ERRORifpy();
  PyTuple_SET_ITEM (tuple, 0, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__f62d65c3c8ab76a77f95ce585cfc2b0c__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0xf62d65c3c8ab76a7ULL, 0x7f95ce585cfc2b0cULL, oid, __AIDA_pyemit1__SignalTestInterface__self_args, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__ChildInheritingSignals__child_signal (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 6;
  PyObject *result = NULL, *tuple = PyTuple_New (length), *item;
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  item = __AIDA_pyfactory__create_from_orbid (fbr.pop_object()); ERRORifpy();
  PyTuple_SET_ITEM (tuple, 0, item);
  item = __AIDA_pyfactory__create_from_orbid (fbr.pop_object()); ERRORifpy();
  PyTuple_SET_ITEM (tuple, 1, item);
  item = __AIDA_pyconvert__pyany_from_any (fbr.pop_any()); ERRORifpy();
  PyTuple_SET_ITEM (tuple, 2, item);
  item = PyLong_FromLongLong (fbr.pop_int64()); ERRORifpy ();
  PyTuple_SET_ITEM (tuple, 3, item);
  item = aida_pyQuickRecord_proto_pop (fbr); ERRORif (!item);
  PyTuple_SET_ITEM (tuple, 4, item);
  item = aida_pyQuickSequence_proto_pop (fbr); ERRORif (!item);
  PyTuple_SET_ITEM (tuple, 5, item);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__0b181d52b5db5237d1c6370677791f5a__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x0b181d52b5db5237ULL, 0xd1c6370677791f5aULL, oid, __AIDA_pyemit1__ChildInheritingSignals__child_signal, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static PyObject*
__AIDA_pygetter__14469c03fdfc61e43bb8a3b5d9832788__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.bool_prop
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x14469c03fdfc61e4ULL, 0x3bb8a3b5d9832788ULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyLong_FromLongLong (frr.pop_bool()); ERRORifpy ();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__a88d7a16adc7ad4333e7a32598f08880__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.bool_prop
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xa88d7a16adc7ad43ULL, 0x33e7a32598f08880ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_bool (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__8a2f1538f2b852fb7d3e8ea6f069a1c0__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.int32_prop
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x8a2f1538f2b852fbULL, 0x7d3e8ea6f069a1c0ULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyLong_FromLongLong (frr.pop_int64()); ERRORifpy ();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__7b7b3182160469e4bd3c44c3a57484eb__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.int32_prop
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0x7b7b3182160469e4ULL, 0xbd3c44c3a57484ebULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__c9bb6114fc5c90de400dff0f59e66f63__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.int64_prop
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xc9bb6114fc5c90deULL, 0x400dff0f59e66f63ULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyLong_FromLongLong (frr.pop_int64()); ERRORifpy ();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__b33bf89d2259a1db0154420aebe9a16c__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.int64_prop
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xb33bf89d2259a1dbULL, 0x0154420aebe9a16cULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_int64 (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__b3d53f6a66ba171ec9e2fe1ad9d2d2ab__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.float64_prop
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xb3d53f6a66ba171eULL, 0xc9e2fe1ad9d2d2abULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyFloat_FromDouble (frr.pop_double()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__f1df5bd296ac78e2bb263cff89927093__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.float64_prop
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xf1df5bd296ac78e2ULL, 0xbb263cff89927093ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__d11acce29fa83acfb251b5fc0f737558__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.string_prop
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xd11acce29fa83acfULL, 0xb251b5fc0f737558ULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyString_From_std_string (frr.pop_string()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__fadb1eed1d8d358a17cd2ca684080698__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.string_prop
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xfadb1eed1d8d358aULL, 0x17cd2ca684080698ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_string (PyString_As_std_string (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__42f93106aeb5af11dc4094dc01da9f81__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.enum_prop
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x42f93106aeb5af11ULL, 0xdc4094dc01da9f81ULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = __AIDA_pyfactory__create_enum ("InterfaceTests.QuickEnum", frr.pop_evalue()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__99206fff699c82d61dcbc77498569411__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.enum_prop
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0x99206fff699c82d6ULL, 0x1dcbc77498569411ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_evalue (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__b6ab96740d7834eee7873bec722bb0c8__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.record_prop
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xb6ab96740d7834eeULL, 0xe7873bec722bb0c8ULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = aida_pyQuickRecord_proto_pop (frr); ERRORif (!pyfoR);
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__55aaf8cee9dd7a4683d8416416740bf0__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.record_prop
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0x55aaf8cee9dd7a46ULL, 0x83d8416416740bf0ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  if (!aida_pyQuickRecord_proto_add (item, fb)) goto error;
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__7f96e6ff442ecdd5db054c03831fd75b__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.sequence_prop
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x7f96e6ff442ecdd5ULL, 0xdb054c03831fd75bULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = aida_pyQuickSequence_proto_pop (frr); ERRORif (!pyfoR);
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__f86952a034b8bc843be169a3f0a9a07d__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.sequence_prop
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xf86952a034b8bc84ULL, 0x3be169a3f0a9a07dULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  if (!aida_pyQuickSequence_proto_add (item, fb)) goto error;
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__f3cef8a00677d9318733ca529b58ea4a__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.interface_prop
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xf3cef8a00677d931ULL, 0x8733ca529b58ea4aULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = __AIDA_pyfactory__create_from_orbid (frr.pop_object()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__bf62779e2a11aebb95547f4e29ca3814__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.interface_prop
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xbf62779e2a11aebbULL, 0x95547f4e29ca3814ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_object (PyAttr_As_uint64 (item, "__aida_pyobject__")); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__dd2a04f6c2fc300568868b01ea78948f__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.self_prop
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xdd2a04f6c2fc3005ULL, 0x68868b01ea78948fULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = __AIDA_pyfactory__create_from_orbid (frr.pop_object()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__1a1ee3ab20ab3c2feeaf17826dba2891__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.self_prop
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0x1a1ee3ab20ab3c2fULL, 0xeeaf17826dba2891ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_object (PyAttr_As_uint64 (item, "__aida_pyobject__")); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__b54c6ac2d1c8f9321c8ea2813f2c268e__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.any_prop
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xb54c6ac2d1c8f932ULL, 0x1c8ea2813f2c268eULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = __AIDA_pyconvert__pyany_from_any (frr.pop_any()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__e0c7d397e652f3f7bbdf7826e88f4f42__ (PyObject *pyself, PyObject *pyargs) // PropertyTester.any_prop
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xe0c7d397e652f3f7ULL, 0xbbdf7826e88f4f42ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  { Rapicorn::Aida::Any tmpany;
    __AIDA_pyconvert__pyany_to_any (tmpany, item); ERRORifpy();
    fb.add_any (tmpany); }
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit2__ButtonArea__check_activate (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  FieldReader fbr (*sfb);
  fbr.skip_header();
  fbr.skip();  // skip handler_id
  Rapicorn::Aida::uint64 emit_result_id = fbr.pop_int64();
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
  rb = Rapicorn::Aida::ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_EMIT_RESULT, Rapicorn::Aida::ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), 0x528a0b92de4a958cULL, 0x4d47eecbae62f654ULL, 2);
  *rb <<= emit_result_id;
  if (PyErr_Occurred()) {
    (*rb).add_bool (0);
    goto error;
  } else {
    (*rb).add_bool (PyIntLong_AsLongLong (result)); ERROR_callable_ifpy (callable);
  }
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__528a0b92de4a958c4d47eecbae62f654__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x528a0b92de4a958cULL, 0x4d47eecbae62f654ULL, oid, __AIDA_pyemit2__ButtonArea__check_activate, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static Rapicorn::Aida::FieldBuffer*
__AIDA_pyemit1__ButtonArea__activate (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  Rapicorn::Aida::FieldBuffer *rb = NULL;
  PyObject *callable = (PyObject*) data;
  if (AIDA_UNLIKELY (!sfb)) { Py_DECREF (callable); return NULL; }
  const uint length = 0;
  PyObject *result = NULL, *tuple = PyTuple_New (length);
  if (PyErr_Occurred()) goto error;
  result = PyObject_Call (callable, tuple, NULL);
 error:
  Py_XDECREF (result);
  Py_XDECREF (tuple);
  return rb;
}
static PyObject*
__AIDA_pyconnect__0c46b868988bad84ff7acbea142bbcd0__ (PyObject *pyself, PyObject *pyargs)
{
  while (0) { error: return NULL; }
  if (PyTuple_Size (pyargs) != 1 + 2) ERRORpy ("wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);  // self
  Rapicorn::Aida::uint64 oid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  PyObject *callable = PyTuple_GET_ITEM (pyargs, 1);  // Closure
  Rapicorn::Aida::uint64 result = 0;
  if (callable == Py_None) {
    PyObject *pyo = PyTuple_GET_ITEM (pyargs, 2);
    Rapicorn::Aida::uint64 dc_id = PyIntLong_AsLongLong (pyo); ERRORifpy();
    result = __AIDA_local__client_connection->signal_disconnect (dc_id);
  } else {
    if (!PyCallable_Check (callable)) ERRORpy ("arg2 must be callable");
    Py_INCREF (callable);
    result = __AIDA_local__client_connection->signal_connect (0x0c46b868988bad84ULL, 0xff7acbea142bbcd0ULL, oid, __AIDA_pyemit1__ButtonArea__activate, callable);
  }
  PyObject *pyres = PyLong_FromLongLong (result); ERRORifpy ();
  return pyres;
}
static PyObject*
__AIDA_pygetter__199859aecc756e97a744332174ed27f4__ (PyObject *pyself, PyObject *pyargs) // ButtonArea.on_click
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x199859aecc756e97ULL, 0xa744332174ed27f4ULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyString_From_std_string (frr.pop_string()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__db3a24116c6539852a0576faff45b4b2__ (PyObject *pyself, PyObject *pyargs) // ButtonArea.on_click
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xdb3a24116c653985ULL, 0x2a0576faff45b4b2ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_string (PyString_As_std_string (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__1b448d91990181da9751c08ae956c729__ (PyObject *pyself, PyObject *pyargs) // ButtonArea.on_click2
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x1b448d91990181daULL, 0x9751c08ae956c729ULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyString_From_std_string (frr.pop_string()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__fc93898ba4104662c918694fe5c2bfef__ (PyObject *pyself, PyObject *pyargs) // ButtonArea.on_click2
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xfc93898ba4104662ULL, 0xc918694fe5c2bfefULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_string (PyString_As_std_string (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__5176fbf25dcf50f44d7ae8b51fb816b5__ (PyObject *pyself, PyObject *pyargs) // ButtonArea.on_click3
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0x5176fbf25dcf50f4ULL, 0x4d7ae8b51fb816b5ULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyString_From_std_string (frr.pop_string()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__1c1990dca0fde97c6cc2c7cc49d811f8__ (PyObject *pyself, PyObject *pyargs) // ButtonArea.on_click3
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0x1c1990dca0fde97cULL, 0x6cc2c7cc49d811f8ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_string (PyString_As_std_string (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__b6ab79b43e1f0df9aa0f1ec5c39b704a__ (PyObject *pyself, PyObject *pyargs) // ButtonArea.click_type
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xb6ab79b43e1f0df9ULL, 0xaa0f1ec5c39b704aULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = __AIDA_pyfactory__create_enum ("RapicornAidaTest.ClickType", frr.pop_evalue()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__1f5a6d031cb7e1042d4a207f0842bec8__ (PyObject *pyself, PyObject *pyargs) // ButtonArea.click_type
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0x1f5a6d031cb7e104ULL, 0x2d4a207f0842bec8ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_evalue (PyIntLong_AsLongLong (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__f196563f00b6d48488b59c2ed0597dcc__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xf196563f00b6d484ULL, 0x88b59c2ed0597dccULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // f
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyLong_FromLongLong (frr.pop_int64()); ERRORifpy ();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pycall__d471f88e8c15081c963d2094339d0220__ (PyObject *pyself, PyObject *pyargs)
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 3), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 3) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);  // self
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xd471f88e8c15081cULL, 0x963d2094339d0220ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1); // qr
  if (!aida_pyQuickRecord_proto_add (item, fb)) goto error;
  item = PyTuple_GET_ITEM (pyargs, 2); // qe
  fb.add_evalue (PyIntLong_AsLongLong (item)); ERRORifpy();
  item = PyTuple_GET_ITEM (pyargs, 3); // sr
  if (!aida_pySomeRecord_proto_add (item, fb)) goto error;
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb); // deletes fb
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__dea15f2de1c3d8e3e3fc9febf31cdc20__ (PyObject *pyself, PyObject *pyargs) // Compressor.threshold
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xdea15f2de1c3d8e3ULL, 0xe3fc9febf31cdc20ULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyFloat_FromDouble (frr.pop_double()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__f40a3fd3d07b3d0bbae97c41e3d6a92b__ (PyObject *pyself, PyObject *pyargs) // Compressor.threshold
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0xf40a3fd3d07b3d0bULL, 0xbae97c41e3d6a92bULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pygetter__c61a8d739c7b963bca1ad4eeab1aa56e__ (PyObject *pyself, PyObject *pyargs) // Compressor.ratio
{
  uint64 object_orbid;
  PyObject *item, *pyfoR = NULL;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), __AIDA_local__client_connection->connection_id(), 0xc61a8d739c7b963bULL, 0xca1ad4eeab1aa56eULL);
  fb.add_object (object_orbid);
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  ERRORifnotret (fr);
  if (fr) {
    Rapicorn::Aida::FieldReader frr (*fr);
    frr.skip_header();
    if (frr.remaining() == 1) {
        pyfoR = PyFloat_FromDouble (frr.pop_double()); ERRORifpy();
    }
    delete fr; fr = NULL;
  }
  return pyfoR;
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
static PyObject*
__AIDA_pysetter__302f0b5b99a2a6c8c8b771894ecd9315__ (PyObject *pyself, PyObject *pyargs) // Compressor.ratio
{
  uint64 object_orbid;
  PyObject *item;
  FieldBuffer *fm = FieldBuffer::_new (3 + 1 + 1), &fb = *fm, *fr = NULL;
  if (PyTuple_Size (pyargs) != 1 + 1) ERRORpy ("Aida: wrong number of arguments");
  item = PyTuple_GET_ITEM (pyargs, 0);
  object_orbid = PyAttr_As_uint64 (item, "__aida_pyobject__"); ERRORifpy();
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, Rapicorn::Aida::ObjectBroker::connection_id_from_orbid (object_orbid), 0x302f0b5b99a2a6c8ULL, 0xc8b771894ecd9315ULL);
  fb.add_object (object_orbid);
  item = PyTuple_GET_ITEM (pyargs, 1);
  fb.add_double (PyFloat_AsDouble (item)); ERRORifpy();
  fm = NULL; fr = __AIDA_local__client_connection->call_remote (&fb);
  if (fr) { delete fr; fr = NULL; }
  return None_INCREF();
 error:
  if (fr) delete fr;
  if (fm) delete fm;
  return NULL;
}
#define AIDA_PYSTUB_METHOD_DEFS() \
  { "__AIDA_pyfactory__register_callback", __AIDA_pyfactory__register_callback, METH_VARARGS, "Register Python object factory callable" },\
  { "__AIDA_pycall__c3f858f5171056cb394e47a2bcd63e16__", __AIDA_pycall__c3f858f5171056cb394e47a2bcd63e16__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__d0dd4c08ba5022c0b1af31ca1ec7037a__", __AIDA_pycall__d0dd4c08ba5022c0b1af31ca1ec7037a__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__e4e890540b4c0579e14a7ffaa82f1c4f__", __AIDA_pycall__e4e890540b4c0579e14a7ffaa82f1c4f__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__9cfaa316ccbb6ea06cc5207c5520e081__", __AIDA_pycall__9cfaa316ccbb6ea06cc5207c5520e081__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__64511c410b16c27419b47eb22b4cd4d4__", __AIDA_pycall__64511c410b16c27419b47eb22b4cd4d4__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__2089150ae3f7ad80e6154471cb4560e0__", __AIDA_pycall__2089150ae3f7ad80e6154471cb4560e0__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__349f073a5bad36fdf7a10ae13b8e391b__", __AIDA_pycall__349f073a5bad36fdf7a10ae13b8e391b__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__4b479b2f4e3ba551b7c407eee57eb21a__", __AIDA_pycall__4b479b2f4e3ba551b7c407eee57eb21a__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__dbb304ad4df15873ca276abf2bb1603c__", __AIDA_pycall__dbb304ad4df15873ca276abf2bb1603c__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__b8bc20394724087abc7b1e7d30aeb178__", __AIDA_pycall__b8bc20394724087abc7b1e7d30aeb178__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__3432c3bb41bc72a0533bc22135f973bf__", __AIDA_pycall__3432c3bb41bc72a0533bc22135f973bf__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pyconnect__0774aa0ffbdf5f023f1b5247dca90c86__", __AIDA_pyconnect__0774aa0ffbdf5f023f1b5247dca90c86__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__219d8339499d690e08bca1e9a82f86b0__", __AIDA_pyconnect__219d8339499d690e08bca1e9a82f86b0__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pygetter__f67db704b9d460d6d4950feab697e61e__", __AIDA_pygetter__f67db704b9d460d6d4950feab697e61e__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__7aaf2f96f30428293d0391e5b72e7ba5__", __AIDA_pysetter__7aaf2f96f30428293d0391e5b72e7ba5__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__58ba68f6b64584c9a7d2686edb40f27a__", __AIDA_pygetter__58ba68f6b64584c9a7d2686edb40f27a__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__f0025ec0fa66e3e2880c10e8e6b57cfb__", __AIDA_pysetter__f0025ec0fa66e3e2880c10e8e6b57cfb__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__76ac7a704663d24623abac49621c6802__", __AIDA_pycall__76ac7a704663d24623abac49621c6802__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__1addfccb0a3e01be314f2eb467d7a72b__", __AIDA_pycall__1addfccb0a3e01be314f2eb467d7a72b__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__55291a7348d1424232dac90dde65a764__", __AIDA_pycall__55291a7348d1424232dac90dde65a764__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__dc38cf6855c54108328ddcdcec8f161e__", __AIDA_pycall__dc38cf6855c54108328ddcdcec8f161e__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__678de8636167b6a1b27d37ca066b5335__", __AIDA_pycall__678de8636167b6a1b27d37ca066b5335__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__eea6d5fb184699a3ce05c988a9bfd2d9__", __AIDA_pycall__eea6d5fb184699a3ce05c988a9bfd2d9__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__646f80849d732dc572fd1ede45b153e3__", __AIDA_pycall__646f80849d732dc572fd1ede45b153e3__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__ee3b0b1c6eb52bde13729d2db240b4f9__", __AIDA_pycall__ee3b0b1c6eb52bde13729d2db240b4f9__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__852c7f5942a87cce487dc78cd38240f6__", __AIDA_pycall__852c7f5942a87cce487dc78cd38240f6__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__5534838e08bdc63dd852fd5abb88ab7d__", __AIDA_pycall__5534838e08bdc63dd852fd5abb88ab7d__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__fe9af28dc9c5de7d418be0c0e085ea6d__", __AIDA_pycall__fe9af28dc9c5de7d418be0c0e085ea6d__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__807e5dacf307a2772b65069e50e63c80__", __AIDA_pycall__807e5dacf307a2772b65069e50e63c80__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__be67f4e0afeafd685cdf24c075b03215__", __AIDA_pycall__be67f4e0afeafd685cdf24c075b03215__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pyconnect__e2ae7c707a04333c420330b70d64eb5f__", __AIDA_pyconnect__e2ae7c707a04333c420330b70d64eb5f__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__31529d809bd68e6ba11d55517d4325ae__", __AIDA_pyconnect__31529d809bd68e6ba11d55517d4325ae__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__ac712d196d3466f3eb06bf4f2b2a414c__", __AIDA_pyconnect__ac712d196d3466f3eb06bf4f2b2a414c__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__1439d37d87e2668b57ded621e6b0cde6__", __AIDA_pyconnect__1439d37d87e2668b57ded621e6b0cde6__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__4c5a782eaa76edb0b66fbaa524004fd9__", __AIDA_pyconnect__4c5a782eaa76edb0b66fbaa524004fd9__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__bc5c00f41d7c710d368d920fb6c136e6__", __AIDA_pyconnect__bc5c00f41d7c710d368d920fb6c136e6__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__60702e53aca1b772eac0d39852c951fb__", __AIDA_pyconnect__60702e53aca1b772eac0d39852c951fb__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__755d247d6abfde87093ff68bbb0f5257__", __AIDA_pyconnect__755d247d6abfde87093ff68bbb0f5257__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__b5c453295aa722077c0fa1c12417b139__", __AIDA_pyconnect__b5c453295aa722077c0fa1c12417b139__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__e8ef1fe5de31f95bc0e4bcc410120585__", __AIDA_pyconnect__e8ef1fe5de31f95bc0e4bcc410120585__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__296163d4220985ce40daacab4a841093__", __AIDA_pyconnect__296163d4220985ce40daacab4a841093__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__35828273200534f772873f1374d6093b__", __AIDA_pyconnect__35828273200534f772873f1374d6093b__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__e79b3592345942f66818e92df5df5bef__", __AIDA_pyconnect__e79b3592345942f66818e92df5df5bef__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__495e3d2d698caad7f16b2f75ddaf3220__", __AIDA_pyconnect__495e3d2d698caad7f16b2f75ddaf3220__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__1d335377194859d1fa00c7fb47bc82e4__", __AIDA_pyconnect__1d335377194859d1fa00c7fb47bc82e4__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__52b8b36ec08458caeecdb452f6b51528__", __AIDA_pyconnect__52b8b36ec08458caeecdb452f6b51528__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__dcacb20b2d942f30242d314085f3e44a__", __AIDA_pyconnect__dcacb20b2d942f30242d314085f3e44a__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__9bb22c59672e3921981c8364b2197db9__", __AIDA_pyconnect__9bb22c59672e3921981c8364b2197db9__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__62459d25ac74ebedd598edad744f61b7__", __AIDA_pyconnect__62459d25ac74ebedd598edad744f61b7__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__e4c732769519ca6a8cf6e34972e875aa__", __AIDA_pyconnect__e4c732769519ca6a8cf6e34972e875aa__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__eca8cf0dd80dee4a1bb3845a0704c774__", __AIDA_pyconnect__eca8cf0dd80dee4a1bb3845a0704c774__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__c2562bdab457affd189f1ba486f30579__", __AIDA_pyconnect__c2562bdab457affd189f1ba486f30579__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__445abac8fb3999b7422ee36946f0b021__", __AIDA_pyconnect__445abac8fb3999b7422ee36946f0b021__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__f62d65c3c8ab76a77f95ce585cfc2b0c__", __AIDA_pyconnect__f62d65c3c8ab76a77f95ce585cfc2b0c__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__0b181d52b5db5237d1c6370677791f5a__", __AIDA_pyconnect__0b181d52b5db5237d1c6370677791f5a__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pygetter__14469c03fdfc61e43bb8a3b5d9832788__", __AIDA_pygetter__14469c03fdfc61e43bb8a3b5d9832788__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__a88d7a16adc7ad4333e7a32598f08880__", __AIDA_pysetter__a88d7a16adc7ad4333e7a32598f08880__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__8a2f1538f2b852fb7d3e8ea6f069a1c0__", __AIDA_pygetter__8a2f1538f2b852fb7d3e8ea6f069a1c0__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__7b7b3182160469e4bd3c44c3a57484eb__", __AIDA_pysetter__7b7b3182160469e4bd3c44c3a57484eb__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__c9bb6114fc5c90de400dff0f59e66f63__", __AIDA_pygetter__c9bb6114fc5c90de400dff0f59e66f63__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__b33bf89d2259a1db0154420aebe9a16c__", __AIDA_pysetter__b33bf89d2259a1db0154420aebe9a16c__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__b3d53f6a66ba171ec9e2fe1ad9d2d2ab__", __AIDA_pygetter__b3d53f6a66ba171ec9e2fe1ad9d2d2ab__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__f1df5bd296ac78e2bb263cff89927093__", __AIDA_pysetter__f1df5bd296ac78e2bb263cff89927093__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__d11acce29fa83acfb251b5fc0f737558__", __AIDA_pygetter__d11acce29fa83acfb251b5fc0f737558__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__fadb1eed1d8d358a17cd2ca684080698__", __AIDA_pysetter__fadb1eed1d8d358a17cd2ca684080698__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__42f93106aeb5af11dc4094dc01da9f81__", __AIDA_pygetter__42f93106aeb5af11dc4094dc01da9f81__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__99206fff699c82d61dcbc77498569411__", __AIDA_pysetter__99206fff699c82d61dcbc77498569411__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__b6ab96740d7834eee7873bec722bb0c8__", __AIDA_pygetter__b6ab96740d7834eee7873bec722bb0c8__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__55aaf8cee9dd7a4683d8416416740bf0__", __AIDA_pysetter__55aaf8cee9dd7a4683d8416416740bf0__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__7f96e6ff442ecdd5db054c03831fd75b__", __AIDA_pygetter__7f96e6ff442ecdd5db054c03831fd75b__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__f86952a034b8bc843be169a3f0a9a07d__", __AIDA_pysetter__f86952a034b8bc843be169a3f0a9a07d__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__f3cef8a00677d9318733ca529b58ea4a__", __AIDA_pygetter__f3cef8a00677d9318733ca529b58ea4a__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__bf62779e2a11aebb95547f4e29ca3814__", __AIDA_pysetter__bf62779e2a11aebb95547f4e29ca3814__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__dd2a04f6c2fc300568868b01ea78948f__", __AIDA_pygetter__dd2a04f6c2fc300568868b01ea78948f__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__1a1ee3ab20ab3c2feeaf17826dba2891__", __AIDA_pysetter__1a1ee3ab20ab3c2feeaf17826dba2891__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__b54c6ac2d1c8f9321c8ea2813f2c268e__", __AIDA_pygetter__b54c6ac2d1c8f9321c8ea2813f2c268e__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__e0c7d397e652f3f7bbdf7826e88f4f42__", __AIDA_pysetter__e0c7d397e652f3f7bbdf7826e88f4f42__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pyconnect__528a0b92de4a958c4d47eecbae62f654__", __AIDA_pyconnect__528a0b92de4a958c4d47eecbae62f654__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pyconnect__0c46b868988bad84ff7acbea142bbcd0__", __AIDA_pyconnect__0c46b868988bad84ff7acbea142bbcd0__, METH_VARARGS, "pyRapicorn signal call" },\
  { "__AIDA_pygetter__199859aecc756e97a744332174ed27f4__", __AIDA_pygetter__199859aecc756e97a744332174ed27f4__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__db3a24116c6539852a0576faff45b4b2__", __AIDA_pysetter__db3a24116c6539852a0576faff45b4b2__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__1b448d91990181da9751c08ae956c729__", __AIDA_pygetter__1b448d91990181da9751c08ae956c729__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__fc93898ba4104662c918694fe5c2bfef__", __AIDA_pysetter__fc93898ba4104662c918694fe5c2bfef__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__5176fbf25dcf50f44d7ae8b51fb816b5__", __AIDA_pygetter__5176fbf25dcf50f44d7ae8b51fb816b5__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__1c1990dca0fde97c6cc2c7cc49d811f8__", __AIDA_pysetter__1c1990dca0fde97c6cc2c7cc49d811f8__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__b6ab79b43e1f0df9aa0f1ec5c39b704a__", __AIDA_pygetter__b6ab79b43e1f0df9aa0f1ec5c39b704a__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__1f5a6d031cb7e1042d4a207f0842bec8__", __AIDA_pysetter__1f5a6d031cb7e1042d4a207f0842bec8__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__f196563f00b6d48488b59c2ed0597dcc__", __AIDA_pycall__f196563f00b6d48488b59c2ed0597dcc__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pycall__d471f88e8c15081c963d2094339d0220__", __AIDA_pycall__d471f88e8c15081c963d2094339d0220__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__dea15f2de1c3d8e3e3fc9febf31cdc20__", __AIDA_pygetter__dea15f2de1c3d8e3e3fc9febf31cdc20__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__f40a3fd3d07b3d0bbae97c41e3d6a92b__", __AIDA_pysetter__f40a3fd3d07b3d0bbae97c41e3d6a92b__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pygetter__c61a8d739c7b963bca1ad4eeab1aa56e__", __AIDA_pygetter__c61a8d739c7b963bca1ad4eeab1aa56e__, METH_VARARGS, "pyRapicorn call" },\
  { "__AIDA_pysetter__302f0b5b99a2a6c8c8b771894ecd9315__", __AIDA_pysetter__302f0b5b99a2a6c8c8b771894ecd9315__, METH_VARARGS, "pyRapicorn call" }
static AIDA_UNUSED PyMethodDef dummy[] = { AIDA_PYSTUB_METHOD_DEFS(), { 0 } };
static PyMethodDef __testpass_methods__[] = { AIDA_PYSTUB_METHOD_DEFS(), { 0 } };
PyMODINIT_FUNC init__testpass (void) { Py_InitModule ("__testpass", __testpass_methods__); }
