# Radare2 License

In short, radare2 is mostly LGPLv3, but there are some components with compatible licenses like Apache, BSD or MIT.

The only incompatible part that you may probably need to disable the build of the **GPL** parts which can be disabled with the `--without-gpl` configure flag.

See `doc/licenses/` and `doc/licenses.md`.

To get a fully detailed SBOM report from a runtime build use the `licenses.r2.js` script that will return a JSON object with `-Vj` containing all the license and copyright detailed information of all the elements shipped in the build. Here's a sample output:

```console
$ r2 -qi scripts/licenses.r2.js --

LGPL-3.0-only
capstone BSD-3-Clause OK
sdb MIT OK
arm64v35 Apache-2.0 OK
armv7v35 Apache-2.0 OK
- core
  - a2f : MIT    OK
  - agD : LGPL-3.0-only    OK
  - java : Apache-2.0    OK
  - prj : MIT    OK
  - sixref : MIT    OK
  - r2ai-client : MIT    OK
  - r2dec : BSD-3    OK
  - r2ghidra : GPL3    OK
  - decai : MIT    OK
  - sarif : MIT    OK
  - r2jadx : MIT    OK
  - goresym : MIT    OK
  - codeshare : MIT    OK
- bin
  - any : LGPL-3.0-only    OK
  - art : LGPL-3.0-only    OK
  - avr : LGPL-3.0-only    OK
  - bf : LGPL-3.0-only    OK
  - bflt : LGPL-3.0-only    OK
  - bios : LGPL-3.0-only    OK
  - bootimg : LGPL-3.0-only    OK
  - cgc : LGPL-3.0-only    OK
  - coff : LGPL-3.0-only    OK
  - dex : LGPL-3.0-only    OK
  - dis : MIT    OK
  - dmp64 : LGPL-3.0-only    OK
  - dol : BSD-3-Clause    OK
  - dyldcache : LGPL-3.0-only    OK
  - elf : LGPL-3.0-only    OK
  - elf64 : LGPL-3.0-only    OK
  - fs : LGPL-3.0-only    OK
  - hunk : MIT    OK
  - io : MIT    OK
  - java : LGPL-3.0-only    OK
  - le : LGPL-3.0-only    OK
  - lua : MIT    OK
  - mach0 : LGPL-3.0-only    OK
  - mach064 : LGPL-3.0-only    OK
  - mbn : LGPL-3.0-only    OK
  - mdmp : LGPL-3.0-only    OK
  - menuet : LGPL-3.0-only    OK
  - msx : LGPL-3.0-only    OK
  - mz : MIT    OK
  - ne : LGPL-3.0-only    OK
  - nes : MIT    OK
  - nin3ds : LGPL-3.0-only    OK
  - ninds : LGPL-3.0-only    OK
  - ningb : LGPL-3.0-only    OK
  - ningba : LGPL-3.0-only    OK
  - nro : MIT    OK
  - nso : MIT    OK
  - off : MIT    OK
  - omf : LGPL-3.0-only    OK
  - p9 : MIT    OK
  - pcap : LGPL-3.0-only    OK
  - pdp11 : MIT    OK
  - pe : LGPL-3.0-only    OK
  - pe64 : LGPL-3.0-only    OK
  - pebble : LGPL-3.0-only    OK
  - prg : LGPL-3.0-only    OK
  - psxexe : LGPL-3.0-only    OK
  - pyc : LGPL-3.0-only    OK
  - qnx : LGPL-3.0-only    OK
  - rel : LGPL-3.0-only    OK
  - s390 : LGPL-3.0-only    OK
  - sfc : LGPL-3.0-only    OK
  - smd : LGPL-3.0-only    OK
  - sms : LGPL-3.0-only    OK
  - symbols : MIT    OK
  - te : LGPL-3.0-only    OK
  - tic : MIT    OK
  - uf2 : MIT    OK
  - vsf : LGPL-3.0-only    OK
  - wad : LGPL-3.0-only    OK
  - wasm : MIT    OK
  - xbe : LGPL-3.0-only    OK
  - xcoff64 : LGPL-3.0-only    OK
  - kernelcache : LGPL-3.0-only    OK
  - xtac : Apache-2.0    OK
  - z64 : LGPL-3.0-only    OK
  - zimg : LGPL-3.0-only    OK
- xtr
  - xtr.dyldcache : LGPL-3.0-only    OK
  - xtr.fatmach0 : LGPL-3.0-only    OK
  - xtr.pemixed : LGPL-3.0-only    OK
  - xtr.sep64 : LGPL-3.0-only    OK
  - xtr.xalz : MIT    OK
- ldr
  - xtr.dyldcache : LGPL-3.0-only    OK
  - xtr.fatmach0 : LGPL-3.0-only    OK
  - xtr.pemixed : LGPL-3.0-only    OK
  - xtr.sep64 : LGPL-3.0-only    OK
  - xtr.xalz : MIT    OK
- arch
  - 6502 : LGPL-3.0-only    OK
  - 6502.cs : LGPL-3.0-only    OK
  - 8051 : LGPL-3.0-only    OK
  - alpha : GPL-3.0-only    OK
  - amd29k : BSD-3-Clause    OK
  - any.as : LGPL-3.0-only    OK
  - any.vasm : MIT    OK
  - arc : LGPL-3.0-only    OK
  - arm.nz : LGPL-3.0-only    OK
  - arm : Apache-2.0    OK
  - arm.gnu : GPL-3.0-only    OK
  - arm.v35 : BSD-3-Clause    OK
  - avr : LGPL-3.0-only    OK
  - bf : LGPL-3.0-only    OK
  - bpf.mr : LGPL-3.0-only    OK
  - bpf : BSD-3-Clause    OK
  - chip8 : LGPL-3.0-only    OK
  - cr16 : LGPL-3.0-only    OK
  - cris : LGPL-3.0-only    OK
  - dalvik : LGPL-3.0-only    OK
  - dis : MIT    OK
  - ebc : LGPL-3.0-only    OK
  - evm : BSD-3-Clause    OK
  - fslsp : LGPL-3.0-only    OK
  - gb : LGPL-3.0-only    OK
  - h8300 : LGPL-3.0-only    OK
  - hppa : GPL-3.0-only    OK
  - i4004 : LGPL-3.0-only    OK
  - i8080 : LGPL-3.0-only    OK
  - java : Apache-2.0    OK
  - jdh8 : LGPL-3.0-only    OK
  - kvx : LGPL-3.0-only    OK
  - lanai : GPL-3.0-only    OK
  - lh5801 : LGPL-3.0-only    OK
  - lm32 : BSD-3-Clause    OK
  - loongarch : LGPL-3.0-only    OK
  - lua : MIT    OK
  - m680x : Apache-2.0    OK
  - m68k : BSD-3-Clause    OK
  - m68k.gnu : GPL-3.0-only    OK
  - mcore : LGPL-3.0-only    OK
  - mcs96 : LGPL-3.0-only    OK
  - mips : Apache-2.0    OK
  - mips.gnu : LGPL-3.0-only    OK
  - msp430 : LGPL-3.0-only    OK
  - nds32 : GPL-3.0-only    OK
  - nios2 : LGPL-3.0-only    OK
  - null : LGPL-3.0-only    OK
  - or1k : LGPL-3.0-only    OK
  - pdp11 : GPL-3.0-only    OK
  - pic : LGPL-3.0-only    OK
  - pickle : BSD-3-Clause    OK
  - ppc : Apache-2.0    OK
  - ppc.gnu : LGPL-3.0-only    OK
  - propeller : LGPL-3.0-only    OK
  - pyc : LGPL-3.0-only    OK
  - riscv : GPL-3.0-only    OK
  - riscv.cs : Apache-2.0    OK
  - rsp : LGPL-3.0-only    OK
  - s390 : Apache-2.0    OK
  - s390.gnu : BSD-3-Clause    OK
  - sh : LGPL-3.0-only    OK
  - sh.cs : Apache-2.0    OK
  - sm5xx : BSD-3-Clause    OK
  - snes : LGPL-3.0-only    OK
  - sparc : Apache-2.0    OK
  - sparc.gnu : GPL-3.0-only    OK
  - stm8 : GPL-3.0-only    OK
  - tms320 : LGPL-3.0-only    OK
  - tricore : LGPL-3.0-only    OK
  - tricore.cs : Apache-2.0    OK
  - uxn : MIT    OK
  - v810 : LGPL-3.0-only    OK
  - v850 : MIT    OK
  - vax : GPL-3.0-only    OK
  - wasm : LGPL-3.0-only    OK
  - ws : LGPL-3.0-only    OK
  - x86 : Apache-2.0    OK
  - x86.nasm : LGPL-3.0-only    OK
  - x86.nz : LGPL-3.0-only    OK
  - xap : LGPL-3.0-only    OK
  - xcore : Apache-2.0    OK
  - xtensa : LGPL-3.0-only    OK
  - z80 : GPL-3.0-only    OK
  - r2ghidra : GPL3    OK
- crypto
  - aes-ecb : MIT    OK
  - aes-cbc : LGPL-3.0-only    OK
  - aes-wrap : LGPL-3.0-only    OK
  - base64 : LGPL-3.0-only    OK
  - base91 : MIT    OK
  - bech32 : BSD-3-Clause    OK
  - blowfish : LGPL-3.0-only    OK
  - cps2 : LGPL-3.0-only    OK
  - des-ecb : LGPL-3.0-only    OK
  - ed25519 : Zlib    OK
  - entropy : MIT    OK
  - punycode : LGPL-3.0-only    OK
  - rc2 : LGPL-3.0-only    OK
  - rc4 : LGPL-3.0-only    OK
  - rc6 : LGPL-3.0-only    OK
  - rol : LGPL-3.0-only    OK
  - ror : LGPL-3.0-only    OK
  - rot : MIT    OK
  - serpent-ecb : LGPL-3.0-only    OK
  - sip : MIT    OK
  - sm4-ecb : LGPL-3.0-only    OK
  - strhash : MIT    OK
  - xor : MIT    OK
  - md5 : undefined    [31mERROR[0m
  - sha1 : undefined    [31mERROR[0m
  - sha256 : undefined    [31mERROR[0m
  - sha384 : undefined    [31mERROR[0m
  - sha512 : undefined    [31mERROR[0m
  - md4 : undefined    [31mERROR[0m
  - xor : undefined    [31mERROR[0m
  - xorpair : undefined    [31mERROR[0m
  - parity : undefined    [31mERROR[0m
  - entropy : undefined    [31mERROR[0m
  - hamdist : undefined    [31mERROR[0m
  - pcprint : undefined    [31mERROR[0m
  - mod255 : undefined    [31mERROR[0m
  - xxhash : undefined    [31mERROR[0m
  - adler32 : undefined    [31mERROR[0m
  - luhn : undefined    [31mERROR[0m
  - ssdeep : undefined    [31mERROR[0m
  - crc8smbus : undefined    [31mERROR[0m
  - crc15can : undefined    [31mERROR[0m
  - crc16 : undefined    [31mERROR[0m
  - crc16hdlc : undefined    [31mERROR[0m
  - crc16usb : undefined    [31mERROR[0m
  - crc16citt : undefined    [31mERROR[0m
  - crc24 : undefined    [31mERROR[0m
  - crc32 : undefined    [31mERROR[0m
  - crc32c : undefined    [31mERROR[0m
  - crc32ecma267 : undefined    [31mERROR[0m
  - crc32bzip2 : undefined    [31mERROR[0m
  - crc32d : undefined    [31mERROR[0m
  - crc32mpeg2 : undefined    [31mERROR[0m
  - crc32posix : undefined    [31mERROR[0m
  - crc32q : undefined    [31mERROR[0m
  - crc32jamcrc : undefined    [31mERROR[0m
  - crc32xfer : undefined    [31mERROR[0m
  - crc64 : undefined    [31mERROR[0m
  - crc64ecma : undefined    [31mERROR[0m
  - crc64we : undefined    [31mERROR[0m
  - crc64xz : undefined    [31mERROR[0m
  - crc64iso : undefined    [31mERROR[0m
  - fletcher8 : undefined    [31mERROR[0m
  - fletcher16 : undefined    [31mERROR[0m
  - fletcher32 : undefined    [31mERROR[0m
  - fletcher64 : undefined    [31mERROR[0m
  - elf : undefined    [31mERROR[0m
- debug
  - bf : LGPL-3.0-only    OK
  - bochs : LGPL-3.0-only    OK
  - esil : LGPL-3.0-only    OK
  - evm : LGPL-3.0-only    OK
  - gdb : LGPL-3.0-only    OK
  - io : MIT    OK
  - native : LGPL-3.0-only    OK
  - null : MIT    OK
  - qnx : LGPL-3.0-only    OK
  - rap : LGPL-3.0-only    OK
  - rv32ima : MIT    OK
  - winkd : LGPL-3.0-only    OK
- egg
  - exec : MIT    OK
  - xor : MIT    OK
- fs
  - ext2 : GPL-3.0-only    OK
  - fat : GPL-3.0-only    OK
  - fb : GPL-3.0-only    OK
  - hfs : GPL-3.0-only    OK
  - hfsplus : GPL-3.0-only    OK
  - io : MIT    OK
  - iso9660 : GPL-3.0-only    OK
  - jfs : GPL-3.0-only    OK
  - minix : GPL-3.0-only    OK
  - ntfs : GPL-3.0-only    OK
  - posix : MIT    OK
  - r2 : MIT    OK
  - reiserfs : GPL-3.0-only    OK
  - sfs : GPL-3.0-only    OK
  - squashfs : MIT    OK
  - tar : GPL-3.0-only    OK
  - udf : GPL-3.0-only    OK
  - ufs : GPL-3.0-only    OK
  - xfs : GPL-3.0-only    OK
  - zip : MIT    OK
- io
  - ar : LGPL-3.0-only    OK
  - bfdbg : LGPL-3.0-only    OK
  - bochs : LGPL-3.0-only    OK
  - cyclic : LGPL-3.0-only    OK
  - debug : LGPL-3.0-only    OK
  - default : LGPL-3.0-only    OK
  - dsc : LGPL-3.0-only    OK
  - fd : MIT    OK
  - gdb : LGPL-3.0-only    OK
  - gprobe : LGPL-3.0-only    OK
  - gzip : LGPL-3.0-only    OK
  - http : LGPL-3.0-only    OK
  - ihex : LGPL-3.0-only    OK
  - isotp : MIT    OK
  - mach : LGPL-3.0-only    OK
  - malloc : LGPL-3.0-only    OK
  - mmap : LGPL-3.0-only    OK
  - null : LGPL-3.0-only    OK
  - qnx : GPL-3.0-only    OK
  - r2k : LGPL-3.0-only    OK
  - r2pipe : MIT    OK
  - r2web : LGPL-3.0-only    OK
  - rap : MIT    OK
  - rbuf : LGPL-3.0-only    OK
  - reg : LGPL-3.0-only    OK
  - self : LGPL-3.0-only    OK
  - serial : MIT    OK
  - socket : MIT    OK
  - sparse : LGPL-3.0-only    OK
  - sysgdb : MIT    OK
  - tcp : LGPL-3.0-only    OK
  - treebuf : LGPL-3.0-only    OK
  - uf2 : LGPL-3.0-only    OK
  - winedbg : MIT    OK
  - winkd : LGPL-3.0-only    OK
  - xalz : MIT    OK
  - xattr : LGPL-3.0-only    OK
  - zip : BSD-3-Clause    OK
  - frida : MIT    OK
- lang
  - s : LGPL-3.0-only    OK
  - c : LGPL-3.0-only    OK
  - cpipe : MIT    OK
  - v : MIT    OK
  - vala : LGPL-3.0-only    OK
  - rust : MIT    OK
  - zig : MIT    OK
  - pipe : MIT    OK
  - go : MIT    OK
  - poke : LGPL-3.0-only    OK
  - spp : MIT    OK
  - lib : MIT    OK
  - asm : LGPL-3.0-only    OK
  - qjs : MIT    OK
  - tsc : MIT    OK
  - nim : MIT    OK
```
