% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_multievent.R
\name{plot_multievent}
\alias{plot_multievent}
\title{Plot PSI values of multiple alternative splicing events}
\usage{
plot_multievent(x, config = NULL, subg = FALSE, trim_colnames = NULL,
  qual = c("VLOW", "N", "LOW", "OK", "SOK"), errorbar = TRUE, col = NULL,
  event_col = NULL, title = "MULTI EVENT PLOT", xlab = "", ylab = "PSI",
  ylim = c(0, 100), cex.main = 14, cex.yaxis = 12, cex.xaxis = 12,
  pch = 20, cex.pch = 3, plot = NULL, gridlines = TRUE, lwd = 0.5,
  show_event_legend = T, show_group_legend = T)
}
\arguments{
\item{x}{A data frame containing PSI values to be plotted.}

\item{config}{Optional configuration settings for \code{plot_event}. Can be
a path to the \code{.config} file, or 4/5-column data frame of the \code{.config}
file. Use the latter option if you are calling \code{plot_event} multiple times.}

\item{subg}{Logical indicating whether samples should be subgrouped for plotting.}

\item{trim_colnames}{String that must be searched for and trimmed at the end
of every sample column in x. If no string must be trimmed, leave as \code{FALSE}.}

\item{qual}{String indicating the minimun \emph{vast-tools} quality score
for the PSI to be accepted. Defaults to \code{'VLOW'}. See the
\href{https://github.com/vastgroup/vast-tools/blob/master/README.md}{vast-tools
documentation} for details.}

\item{errorbar}{Logical indicating whether error bars should be drawn}

\item{col}{Vector of colors with length matching the number of samples. If
specified, this will override the color settings specified in \code{config}.}

\item{event_col}{Vector of colors, with length matching the number of events
(rows of \code{x}). If left as \code{NULL}, event colors will be set with
\code{\link[ggplot2]{scale_colour_hue}}}

\item{title}{Title of the plot.}

\item{xlab}{The x-axis label.}

\item{ylab}{The y-axis label.}

\item{ylim}{Range of y-axis.}

\item{cex.main}{Plot title size (pts).}

\item{cex.yaxis}{Y-axis font size (pts).}

\item{cex.xaxis}{X-axis font size (i.e. the sample names) (pts).}

\item{pch}{Point symbol.}

\item{cex.pch}{Size of datapoints.}

\item{plot}{(deprecated) Prints the plot.}

\item{gridlines}{Logical indicating whether grid lines should be drawn.}

\item{lwd}{Line width for errorbars and the line connecting PSIs from each event.}

\item{show_event_legend}{Set to FALSE to avoid showing a legend with the event
IDs and their colors.}

\item{show_group_legend}{Set to FALSE to avoid showing a legend with the sample
groups and their colors.}
}
\value{
ggplot2 object
}
\description{
Generate a plot with PSI values for several exons. The PSI values and
corresponding quality scores are typically obtained from the
\href{https://www.github.com/vastgroup/vast-tools}{vast-tools} pipeline.
}
\details{
Like in \code{\link{plot_event}} and \code{\link{plot_expr}}, plots can be
customized via the \code{config} option. Either a data frame or
the filepath to the config file can be used. Alternatively, plots can be
customized using a limited set of graphical parameters as described above.

See Details of \code{\link{plot_event}} and
\code{\link{preprocess_sample_colors}} for more information on the usage of
the \code{config}, \code{subg}, and \code{errorbar} arguments.

Unlike in \code{\link{plot_event}} and \code{\link{plot_expr}},
sample colors in \code{config} or \code{col} are now shown only in the
background, as the point colors are now used to differentiate PSI values from
different events. In addition, a line connects the points from each event, to
increase visibility. The color of each event can be set using the
\code{event_col} argument.

Also, note that using \code{subg=TRUE} and \code{errorbar=TRUE} together is
an experimental feature, computationally expensive, and CIs may not be shown
for some subgroups, especially for events with low coverage and PSI values near
0 or 1 (see \code{\link{get_beta_ci_subg}} for details on error bar estimation
for subgrouped samples).
}
\examples{
plot_multievent(psi, config = config)

# Example with subgrouped samples, custom title and no error bars
plot_multievent(psi, config = config, subg = TRUE, errorbar = FALSE, title = "Highlighted events")

# Legends can be hidden separately
plot_multievent(psi, config = config, show_event_legend = FALSE)
plot_multievent(psi, config = config, show_group_legend = FALSE)

# Custom event colors
plot_multievent(psi[1:3,], config = config, event_col=c("red","black","orange"))

# Use of errobar = TRUE and subg = TRUE is experimental and computationally expensive
\dontrun{
plot_multievent(psi, config = config, subg = TRUE, errorbar = TRUE)
}

}
\seealso{
\code{\link{format_table}} for performing some initial conversion steps of
\code{x}.

\code{\link{preprocess_sample_colors}} for pre-processing of \code{x}
using\code{config}.

\code{\link{plot_event}} for plotting single events.
}
