% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_words.R
\name{get_stopwords}
\alias{get_stopwords}
\title{Get a tidy data frame of a single stopword lexicon}
\usage{
get_stopwords(language = "en", source = "snowball")
}
\arguments{
\item{language}{The language of the stopword lexicon specified as a
two-letter ISO code, such as \code{"es"}, \code{"de"}, or \code{"fr"}.
Default is \code{"en"} for English. Use
\link[stopwords]{stopwords_getlanguages} from \pkg{stopwords} to see available
languages.}

\item{source}{The source of the stopword lexicon specified. Default is
\code{"snowball"}. Use \link[stopwords]{stopwords_getsources} from
\pkg{stopwords} to see available sources.}
}
\value{
A tibble with two columns, \code{word} and \code{lexicon}. The
parameter \code{lexicon} is "quanteda" in this case.
}
\description{
Get a specific stop word lexicon via the \pkg{stopwords} package's
\link[stopwords]{stopwords} function, in a tidy format with one word per row.
}
\examples{

library(dplyr)
get_stopwords()
get_stopwords(source = "smart")
get_stopwords("es", "snowball")
get_stopwords("ru", "snowball")

}
