% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{mutation.network}
\alias{mutation.network}
\title{Make mutation network for the given repertoire.}
\usage{
mutation.network(.data, .method = c("hamm", "lev"), .max.errors = 1,
  .label.col = "CDR3.amino.acid.sequence", .seg.col = "V.gene",
  .prob.col = "Probability")
}
\arguments{
\item{.data}{Either character vector of sequences, data frame with \code{.label.col}
or shared repertoire (result from the \code{shared.repertoire} function) constructed based on \code{.label.col}.}

\item{.method}{Either "hamm" (for hamming distance) or "lev" (for edit distance). Passed to the \code{find.similar.sequences} function.}

\item{.max.errors}{Passed to the \code{find.similar.sequences} function.}

\item{.label.col}{Name of the column with CDR3 sequences (vertex labels).}

\item{.seg.col}{Name of the column with V gene segments.}

\item{.prob.col}{Name of the column with clonotype probability.}
}
\value{
Mutation network, i.e. igraph object with input sequences as vertices labels, ???
}
\description{
Mutation network (or a mutation graph) is a graph with vertices representing nucleotide or in-frame amino acid sequences (out-of-frame amino acid sequences
will automatically filtered out) and edges are connecting pairs of sequences with hamming distance or edit distance between them
no more than specified in the \code{.max.errors} function parameter.
}
\examples{
\dontrun{
data(twb)
twb.shared <- shared.repertoire(twb)
G <- mutation.network(twb.shared)
get.people.names(G, 300, T)  # "Subj.A|Subj.B"
get.people.names(G, 300, F)  # list(c("Subj.A", "Subj.B"))
}
}
\seealso{
\link{shared.repertoire}, \link{find.similar.sequences}, \link{set.people.vector}, \link{get.people.names}
}
