% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tpsid.R
\name{get_tpsid}
\alias{get_tpsid}
\alias{as.tpsid}
\alias{as.tpsid.tpsid}
\alias{as.tpsid.character}
\alias{as.tpsid.list}
\alias{as.tpsid.numeric}
\alias{as.tpsid.data.frame}
\alias{as.data.frame.tpsid}
\alias{get_tpsid_}
\title{Get the NameID codes from Tropicos for taxonomic names.}
\usage{
get_tpsid(
  sciname,
  ask = TRUE,
  messages = TRUE,
  key = NULL,
  rows = NA,
  family = NULL,
  rank = NULL,
  ...
)

as.tpsid(x, check = TRUE)

\method{as.tpsid}{tpsid}(x, check = TRUE)

\method{as.tpsid}{character}(x, check = TRUE)

\method{as.tpsid}{list}(x, check = TRUE)

\method{as.tpsid}{numeric}(x, check = TRUE)

\method{as.tpsid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{tpsid}(x, ...)

get_tpsid_(sciname, messages = TRUE, key = NULL, rows = NA, ...)
}
\arguments{
\item{sciname}{(character) One or more scientific name's as a vector or list. Or,
a \code{taxon_state} object (see \link{taxon-state})}

\item{ask}{logical; should get_tpsid be run in interactive mode?
If TRUE and more than one ID is found for the species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{messages}{logical; If TRUE the actual taxon queried is printed on the console.}

\item{key}{Your API key; see \link{taxize-authentication}}

\item{rows}{numeric; Any number from 1 to infinity. If the default NA, all rows are considered.
Note that this function still only gives back a tpsid class object with one to many identifiers.
See \code{\link[=get_tpsid_]{get_tpsid_()}} to get back all, or a subset, of the raw data that you are
presented during the ask process.}

\item{family}{(character) A family name. Optional. See \code{Filtering} below.}

\item{rank}{(character) A taxonomic rank name. See \code{\link[=rank_ref]{rank_ref()}} for possible
options. Though note that some data sources use atypical ranks, so inspect the
data itself for options. Optional. See \code{Filtering} below.}

\item{...}{Other arguments passed to \code{\link[=tp_search]{tp_search()}}.}

\item{x}{Input to \code{\link[=as.tpsid]{as.tpsid()}}}

\item{check}{logical; Check if ID matches any existing on the DB, only used in
\code{\link[=as.tpsid]{as.tpsid()}}}
}
\value{
A vector of taxonomic identifiers as an S3 class.
If a taxon is not found an \code{NA} is given. If more than one identifier
is found the function asks for user input if \code{ask = TRUE}, otherwise
returns \code{NA}. If \code{ask=FALSE} and \code{rows} does not equal
\code{NA}, then a data.frame is given back, but not of the uid class, which
you can't pass on to other functions as you normally can.

See \code{\link{get_id_details}} for further details including
attributes and exceptions
}
\description{
Get the NameID codes from Tropicos for taxonomic names.
}
\section{Filtering}{

The parameters \code{family} an\code{rank}nk are not used in the search to the data
provider, but are used in filtering the data down to a subset that is closer to the
target you want.  For all these parameters,
you can use regex strings since we use \code{\link[=grep]{grep()}} internally to match.
Filtering narrows down to the set that matches your query, and removes the rest.
}

\examples{
\dontrun{
get_tpsid(sciname='Poa annua')
get_tpsid(sciname='Pinus contorta')

get_tpsid(c("Poa annua", "Pinus contorta"))

# specify rows to limit choices available
get_tpsid('Poa ann')
get_tpsid('Poa ann', rows=1)
get_tpsid('Poa ann', rows=25)
get_tpsid('Poa ann', rows=1:2)

# When not found, NA given (howdy is not a species name, and Chrinomus is a fly)
get_tpsid("howdy")
get_tpsid(c("Chironomus riparius", "howdy"))

# Narrow down results to a division or rank, or both
## Satyrium example
### Results w/o narrowing
get_tpsid("Satyrium")
### w/ rank
get_tpsid("Satyrium", rank = "var.")
get_tpsid("Satyrium", rank = "sp.")

## w/ family
get_tpsid("Poa")
get_tpsid("Poa", family = "Iridaceae")
get_tpsid("Poa", family = "Orchidaceae")
get_tpsid("Poa", family = "Orchidaceae", rank = "gen.")

# Fuzzy filter on any filtering fields
## uses grep on the inside
get_tpsid("Poa", family = "orchidaceae")
get_tpsid("Aga", fuzzy = TRUE, parent = "*idae")

# pass to classification function to get a taxonomic hierarchy
classification(get_tpsid(sciname='Poa annua'))

# pass in a list, works fine
get_tpsid(list("Poa annua", "Pinus contorta"))

# Convert a tpsid without class information to a tpsid class
as.tpsid(get_tpsid("Pinus contorta")) # already a tpsid, returns the same
as.tpsid(get_tpsid(c("Chironomus riparius","Pinus contorta"))) # same
as.tpsid(24900183) # numeric
as.tpsid(c(24900183,50150089,50079838)) # numeric vector, length > 1
as.tpsid("24900183") # character
as.tpsid(c("24900183","50150089","50079838")) # character vector, length > 1
as.tpsid(list("24900183","50150089","50079838")) # list, either numeric or character
## dont check, much faster
as.tpsid("24900183", check=FALSE)
as.tpsid(24900183, check=FALSE)
as.tpsid(c("24900183","50150089","50079838"), check=FALSE)
as.tpsid(list("24900183","50150089","50079838"), check=FALSE)

(out <- as.tpsid(c(24900183,50150089,50079838)))
data.frame(out)
as.tpsid( data.frame(out) )

# Get all data back
get_tpsid_("Poa annua")
get_tpsid_("Poa annua", rows=2)
get_tpsid_("Poa annua", rows=1:2)
get_tpsid_(c("asdfadfasd","Pinus contorta"), rows=1:5)

# use curl options
invisible(get_tpsid("Quercus douglasii", messages = TRUE))
}
}
\seealso{
\code{\link[=classification]{classification()}}

Other taxonomic-ids: 
\code{\link{get_boldid}()},
\code{\link{get_eolid}()},
\code{\link{get_gbifid}()},
\code{\link{get_ids}()},
\code{\link{get_iucn}()},
\code{\link{get_natservid}()},
\code{\link{get_nbnid}()},
\code{\link{get_pow}()},
\code{\link{get_tolid}()},
\code{\link{get_tsn}()},
\code{\link{get_uid}()},
\code{\link{get_wiki}()},
\code{\link{get_wormsid}()}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}
\concept{taxonomic-ids}
