% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxize_cite.R
\name{taxize_cite}
\alias{taxize_cite}
\title{Get citations and licenses for data sources used in taxize}
\usage{
taxize_cite(fxn = "itis", what = "citation")
}
\arguments{
\item{fxn}{Function to search on. A special case is the package name
'taxize' that will give the citations for the package.}

\item{what}{One of citation (default), license, or both.}
}
\description{
Get citations and licenses for data sources used in taxize
}
\examples{
taxize_cite(fxn='eol_search')
taxize_cite(fxn='itis_hierarchy')
taxize_cite(fxn='tp_classification')
taxize_cite(fxn='gbif_ping')
taxize_cite(fxn='plantminer')
taxize_cite(fxn='get_natservid_')
taxize_cite(fxn='as.natservid')
taxize_cite(fxn='get_wormsid')
taxize_cite(fxn='as.wormsid')

# Functions that use many data sources
taxize_cite(fxn='synonyms')
taxize_cite(fxn='classification')

# Get the taxize citation
taxize_cite(fxn='taxize')

# Get license information
taxize_cite(fxn='taxize', "license")
}
