% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev_strings.R
\name{string_metrics_dev}
\alias{string_metrics_dev}
\title{Get string metrics as measured by the current device}
\usage{
string_metrics_dev(
  strings,
  family = "",
  face = 1,
  size = 12,
  cex = 1,
  unit = "cm"
)
}
\arguments{
\item{strings}{A character vector of strings to measure}

\item{family}{The font families to use. Will get recycled}

\item{face}{The font faces to use. Will get recycled}

\item{size}{The font size to use. Will get recycled}

\item{cex}{The cex multiplier to use. Will get recycled}

\item{unit}{The unit to return the width in. Either \code{"cm"}, \code{"inches"},
\code{"device"}, or \code{"relative"}}
}
\value{
A data.frame with \code{width}, \code{ascent}, and \code{descent} columns giving the
metrics in the requested unit.
}
\description{
This function is much like \code{\link[=string_widths_dev]{string_widths_dev()}} but also returns the ascent
and descent of the string making it possible to construct a tight bounding
box around the string.
}
\examples{
# Get the metrics as measured in cm (default)
string_metrics_dev(c('some text', 'a string with descenders'))

}
\seealso{
Other device metrics: 
\code{\link{string_widths_dev}()}
}
\concept{device metrics}
