% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_deletealias.R
\name{collection_deletealias}
\alias{collection_deletealias}
\title{Delete a collection alias}
\usage{
collection_deletealias(conn, alias, raw = FALSE, callopts = list())
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{alias}{(character) Required. The alias name to be created}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Delete a collection alias
}
\examples{
\dontrun{
(conn <- SolrClient$new())

if (!conn$collection_exists("thingsstuff")) {
  conn$collection_create(name = "thingsstuff")
}

conn$collection_createalias("tstuff", "thingsstuff")
conn$collection_clusterstatus()$cluster$collections$thingsstuff$aliases # new alias
conn$collection_deletealias("tstuff")
conn$collection_clusterstatus()$cluster$collections$thingsstuff$aliases # gone
}
}
