% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate_df.R
\name{rotate_df}
\alias{rotate_df}
\title{Rotate a data frame}
\usage{
rotate_df(x, rn = NULL, cn = FALSE)
}
\arguments{
\item{x}{A data frame.}

\item{rn}{Character vector (optional). If not \code{NULL}, the data frame's
rownames will be added as (first) column to the output, with
\code{rn} being the name of this column.}

\item{cn}{Logical (optional), if \code{TRUE}, the values of the first column
in \code{x} will be used as column names in the rotated data frame.}
}
\value{
A (rotated) data frame.
}
\description{
This function rotates a data frame, i.e. columns become rows
             and vice versa.
}
\examples{
x <- mtcars[1:3, 1:4]
rotate_df(x)
rotate_df(x, rn = "property")

# use values in 1. column as column name
rotate_df(x, cn = TRUE)
rotate_df(x, rn = "property", cn = TRUE)

# also works on list-results
library(purrr)

dat <- mtcars[1:3, 1:4]
tmp <- purrr::map(dat, function(x) {
  sdev <- stats::sd(x, na.rm = TRUE)
  ulsdev <- mean(x, na.rm = TRUE) + c(-sdev, sdev)
  names(ulsdev) <- c("lower_sd", "upper_sd")
  ulsdev
})
tmp
as.data.frame(tmp)
rotate_df(tmp)

tmp <- purrr::map_df(dat, function(x) {
  sdev <- stats::sd(x, na.rm = TRUE)
  ulsdev <- mean(x, na.rm = TRUE) + c(-sdev, sdev)
  names(ulsdev) <- c("lower_sd", "upper_sd")
  ulsdev
})
tmp
rotate_df(tmp)

}
