% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.R
\name{gdal}
\alias{gdal}
\alias{gdal_read}
\alias{gdal_write}
\alias{gdal_inv_geotransform}
\alias{gdal_crs}
\alias{gdal_metadata}
\alias{gdal_subdatasets}
\alias{gdal_polygonize}
\alias{gdal_rasterize}
\alias{gdal_extract}
\alias{gdal_read_mdim}
\alias{gdal_write_mdim}
\alias{gdal_create}
\title{functions to interact with gdal not meant to be called directly by users (but e.g. by stars::read_stars)}
\usage{
gdal_read(
  x,
  ...,
  options = character(0),
  driver = character(0),
  read_data = TRUE,
  NA_value = NA_real_,
  RasterIO_parameters = list()
)

gdal_write(
  x,
  ...,
  file,
  driver = "GTiff",
  options = character(0),
  type = "Float32",
  NA_value = NA_real_,
  geotransform,
  update = FALSE
)

gdal_inv_geotransform(gt)

gdal_crs(file, options = character(0))

gdal_metadata(
  file,
  domain_item = character(0),
  options = character(0),
  parse = TRUE
)

gdal_subdatasets(file, options = character(0), name = TRUE)

gdal_polygonize(
  x,
  mask = NULL,
  file = tempfile(),
  driver = "GTiff",
  use_integer = TRUE,
  geotransform,
  breaks = classInt::classIntervals(na.omit(as.vector(x[[1]])))$brks,
  use_contours = FALSE,
  contour_lines = FALSE,
  connect8 = FALSE,
  ...
)

gdal_rasterize(sf, x, gt, file, driver = "GTiff", options = character())

gdal_extract(f, pts, bilinear = FALSE)

gdal_read_mdim(file, array_name = character(0), options = character(0))

gdal_write_mdim(x, file, dimension_values, units)

gdal_create(f, nxy, values, crs, xlim, ylim)
}
\arguments{
\item{x}{character vector, possibly of length larger than 1 when more than one raster is read}

\item{...}{ignored}

\item{options}{open options}

\item{driver}{character; when empty vector, driver is auto-detected.}

\item{read_data}{logical; if \code{FALSE}, only the imagery metadata is returned}

\item{NA_value}{(double) non-NA value to use for missing values; if \code{NA}, when writing missing values are not specially flagged in output dataset, when reading the default (dataset) missing values are used (if present / set).}

\item{RasterIO_parameters}{list with named parameters to GDAL's RasterIO; see the stars::read_stars documentation.}

\item{file}{file name}

\item{type}{gdal write type}

\item{geotransform}{length 6 numeric vector with GDAL geotransform parameters.}

\item{update}{logical; \code{TRUE} if in an existing raster file pixel values shall be updated.}

\item{gt}{double vector of length 6}

\item{domain_item}{character vector of length 0, 1 (with domain), or 2 (with domain and item); use \code{""} for the default domain, use \code{NA_character_} to query the domain names.}

\item{parse}{logical; should metadata be parsed into a named list (\code{TRUE}) or returned as character data?}

\item{name}{logical; retrieve name of subdataset? If \code{FALSE}, retrieve description}

\item{mask}{stars object with NA mask (0 where NA), or NULL}

\item{use_integer}{boolean; if \code{TRUE}, raster values are read as (and rounded to) unsigned 32-bit integers values; if \code{FALSE} they are read as 32-bit floating points numbers. The former is supposedly faster.}

\item{breaks}{numeric vector with break values for contour polygons (or lines)}

\item{use_contours}{logical;}

\item{contour_lines}{logical;}

\item{connect8}{logical; if \code{TRUE} use 8 connection algorithm, rather than 4}

\item{sf}{object of class \code{sf}}

\item{f}{character; file name}

\item{pts}{points matrix}

\item{bilinear}{logical; use bilinear interpolation, rather than nearest neighbor?}

\item{array_name}{array name}

\item{dimension_values}{list with dimension values}

\item{units}{character; units names (udunits conform) corresponding to dimension_values}

\item{nxy}{integer vector of length 2}

\item{values}{fill value}

\item{crs}{object of class \code{crs}}

\item{xlim}{numeric}

\item{ylim}{numeric}
}
\value{
object of class \code{crs}, see \link{st_crs}.

named list with metadata items

\code{gdal_subdatasets} returns a zero-length list if \code{file} does not have subdatasets, and else a named list with subdatasets.
}
\description{
functions to interact with gdal not meant to be called directly by users (but e.g. by stars::read_stars)
}
\details{
These functions are exported for the single purpose of being used by package stars, they are not meant to be used directly and may change or disappear without prior notice or deprecation warnings.

gdal_inv_geotransform returns the inverse geotransform

gdal_crs reads coordinate reference system from GDAL data set

get_metadata gets metadata of a raster layer

gdal_subdatasets returns the subdatasets of a gdal dataset
}
\examples{
\dontrun{
  f = system.file("tif/L7_ETMs.tif", package="stars")
  f = system.file("nc/avhrr-only-v2.19810901.nc", package = "stars")
  gdal_metadata(f)
  gdal_metadata(f, NA_character_)
  try(gdal_metadata(f, "wrongDomain"))
  gdal_metadata(f, c("", "AREA_OR_POINT"))
}
}
