% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction.R
\name{ProjectDim}
\alias{ProjectDim}
\title{Project Dimensional reduction onto full dataset}
\usage{
ProjectDim(
  object,
  reduction = "pca",
  assay = NULL,
  dims.print = 1:5,
  nfeatures.print = 20,
  overwrite = FALSE,
  do.center = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{Seurat object}

\item{reduction}{Reduction to use}

\item{assay}{Assay to use}

\item{dims.print}{Number of dims to print features for}

\item{nfeatures.print}{Number of features with highest/lowest loadings to print for
each dimension}

\item{overwrite}{Replace the existing data in feature.loadings}

\item{do.center}{Center the dataset prior to projection (should be set to TRUE)}

\item{verbose}{Print top genes associated with the projected dimensions}
}
\value{
Returns Seurat object with the projected values
}
\description{
Takes a pre-computed dimensional reduction (typically calculated on a subset
of genes) and projects this onto the entire dataset (all genes). Note that
the cell loadings will remain unchanged, but now there are gene loadings for
all genes.
}
\examples{
data("pbmc_small")
pbmc_small
pbmc_small <- ProjectDim(object = pbmc_small, reduction = "pca")
# Visualize top projected genes in heatmap
DimHeatmap(object = pbmc_small, reduction = "pca", dims = 1, balanced = TRUE)

}
\concept{dimensional_reduction}
