% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{PredictAssay}
\alias{PredictAssay}
\title{Predict value from nearest neighbors}
\usage{
PredictAssay(
  object,
  nn.idx,
  assay,
  reduction = NULL,
  dims = NULL,
  return.assay = TRUE,
  slot = "scale.data",
  features = NULL,
  mean.function = rowMeans,
  seed = 4273,
  verbose = TRUE
)
}
\arguments{
\item{object}{The object used to calculate knn}

\item{nn.idx}{k near neighbor indices. A cells x k matrix.}

\item{assay}{Assay used for prediction}

\item{reduction}{Cell embedding of the reduction used for prediction}

\item{dims}{Number of dimensions of cell embedding}

\item{return.assay}{Return an assay or a predicted matrix}

\item{slot}{slot used for prediction}

\item{features}{features used for prediction}

\item{mean.function}{the function used to calculate row mean}

\item{seed}{Sets the random seed to check if the nearest neighbor is query
cell}

\item{verbose}{Print progress}
}
\value{
return an assay containing predicted expression value in the data
slot
}
\description{
This function will predict expression or cell embeddings from its k nearest
neighbors index. For each cell, it will average its k neighbors value to get
its new imputed value. It can average expression value in assays and cell
embeddings from dimensional reductions.
}
\concept{integration}
