% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-version.R
\name{install_version}
\alias{install_version}
\title{Install specified version of a CRAN package.}
\usage{
install_version(
  package,
  version = NULL,
  dependencies = NA,
  upgrade = c("default", "ask", "always", "never"),
  force = FALSE,
  quiet = FALSE,
  build = FALSE,
  build_opts = c("--no-resave-data", "--no-manual", "--no-build-vignettes"),
  build_manual = FALSE,
  build_vignettes = FALSE,
  repos = getOption("repos"),
  type = "source",
  ...
)
}
\arguments{
\item{package}{package name}

\item{version}{If the specified version is NULL or the same as the most
recent version of the package, this function simply calls
\code{\link[utils:install.packages]{utils::install.packages()}}. Otherwise, it looks at the list of
archived source tarballs and tries to install an older version instead.}

\item{dependencies}{logical indicating whether to also install
    uninstalled packages which these packages depend on/link
    to/import/suggest (and so on recursively).
    Not used if \code{repos = NULL}.
    Can also be a character vector, a subset of
    \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.

    Only supported if \code{lib} is of length one (or missing),
    so it is unambiguous where to install the dependent packages.  If
    this is not the case it is ignored, with a warning.

    The default, \code{NA}, means
    \code{c("Depends", "Imports", "LinkingTo")}.

    \code{TRUE} means to use
    \code{c("Depends", "Imports", "LinkingTo", "Suggests")} for
    \code{pkgs} and
    \code{c("Depends", "Imports", "LinkingTo")} for added dependencies:
    this installs all the packages needed to run \code{pkgs}, their
    examples, tests and vignettes (if the package author specified them
    correctly).

    In all of these, \code{"LinkingTo"} is omitted for binary packages.
  }

\item{upgrade}{One of "default", "ask", "always", or "never". "default"
respects the value of the \code{R_REMOTES_UPGRADE} environment variable if set,
and falls back to "ask" if unset. "ask" prompts the user for which out of
date packages to upgrade. For non-interactive sessions "ask" is equivalent
to "always". \code{TRUE} and \code{FALSE} are also accepted and correspond to
"always" and "never" respectively.}

\item{force}{Force installation, even if the remote state has not changed
since the previous install.}

\item{quiet}{
    logical: if true, reduce the amount of output.
  }

\item{build}{If \code{TRUE} build the package before installing.}

\item{build_opts}{Options to pass to \verb{R CMD build}, only used when \code{build}}

\item{build_manual}{If \code{FALSE}, don't build PDF manual ('--no-manual').}

\item{build_vignettes}{If \code{FALSE}, don't build package vignettes ('--no-build-vignettes').
is \code{TRUE}.}

\item{repos}{
    character vector, the base URL(s) of the repositories
    to use, e.g., the URL of a CRAN mirror such as
    \code{"https://cloud.r-project.org"}.  For more details on
    supported URL schemes see \code{\link{url}}.

    Can be \code{NULL} to install from local files, directories or URLs:
    this will be inferred by extension from \code{pkgs} if of length one.
  }

\item{type}{character, indicating the type of package to download and
    install.  Will be \code{"source"} except on Windows and some macOS
    builds: see the section on \sQuote{Binary packages} for those.
  }

\item{...}{Other arguments passed on to \code{\link[utils:install.packages]{utils::install.packages()}}.}
}
\description{
If you are installing an package that contains compiled code, you will
need to have an R development environment installed.  You can check
if you do by running \code{devtools::has_devel} (you need the
\code{devtools} package for this).
}
\seealso{
Other package installation: 
\code{\link{install_bioc}()},
\code{\link{install_bitbucket}()},
\code{\link{install_cran}()},
\code{\link{install_dev}()},
\code{\link{install_github}()},
\code{\link{install_gitlab}()},
\code{\link{install_git}()},
\code{\link{install_local}()},
\code{\link{install_svn}()},
\code{\link{install_url}()}
}
\author{
Jeremy Stephens
}
\concept{package installation}
