\name{rs.br}
\alias{rs.br}
\alias{plot.rs.br}
\alias{print.rs.br}


\title{Test the Proportional Hazards Assumption for Relative Survival
 Regression Models}
\description{
Test the proportional hazards assumption for relative survival  models  (\code{rsadd}, \code{rsmul} or \code{rstrans})
by forming a Brownian Bridge. }
\usage{
rs.br(fit,sc,rho=0,test="max",global=TRUE)
}

\arguments{
\item{fit}{
the result of fitting a relative survival model, using the
          \code{rsadd}, \code{rsmul} or \code{rstrans} function. 
}
\item{sc}{
partial residuals calculated by the \code{resid} function. This is used to save time if several tests
are to be calculated on these residuals and can otherwise be omitted.
}
\item{rho}{
a number controlling the weigths of residuals. The weights are the number of individuals at
risk at each event time to the power \code{rho}. The default is \code{rho=0}, which sets all
weigths to 1.
}
\item{test}{ 
a character string specifying the test to be performed on Brownian bridge.
Possible values are \code{"max"} (default), which tests the maximum absolute value of the 
bridge, and \code{cvm}, which calculates the Cramer Von Mises statistic.
}
\item{global}{should a global Brownian bridge test be performed, in addition to the
          per-variable tests}

}

\value{
 an object of class \code{rs.br}. This function would usually be followed by both a
print and a plot of the result. The plot gives a Brownian bridge for each of the variables.
The horizontal lines are the 95% and 99% confidence intervals for the maximum absolute value
of the Brownian bridge}




\references{
Goodness of fit: Stare J.,Pohar Perme M., Henderson R. (2005) "Goodness of fit of relative survival models." Statistics in Medicine, \bold{24}: 3911--3925.

Package. Pohar M., Stare J. (2006) "Relative survival analysis in R." Computer Methods and Programs in Biomedicine, \bold{81}: 272--278

Relative survival: Pohar, M., Stare, J. (2007) "Making relative survival analysis relatively easy."
Computers in biology and medicine, \bold{37}: 1741--1749.

}



\examples{
data(slopop)
data(rdata)
fit <- rsadd(Surv(time,cens)~sex,rmap=list(age=age*365.241),
		ratetable=slopop,data=rdata,int=5)
rsbr <- rs.br(fit)
rsbr
plot(rsbr)
}

\seealso{\code{\link{rsadd}}, \code{rsmul}, \code{rstrans}, \code{\link{resid}}.}

\keyword{survival}
