% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_environ}
\alias{ps_environ}
\alias{ps_environ_raw}
\title{Environment variables of a process}
\usage{
ps_environ(p = ps_handle())

ps_environ_raw(p = ps_handle())
}
\arguments{
\item{p}{Process handle.}
}
\value{
\code{ps_environ()} returns a named character vector (that has a
\code{Dlist} class, so it is printed nicely), \code{ps_environ_raw()} returns a
character vector.
}
\description{
\code{ps_environ()} returns the environment variables of the process, in a
named vector, similarly to the return value of \code{Sys.getenv()}
(without arguments).
}
\details{
Note: this usually does not reflect changes made after the process
started.

\code{ps_environ_raw()} is similar to \code{p$environ()} but returns the
unparsed \code{"var=value"} strings. This is faster, and sometimes good
enough.

These functions throw a \code{zombie_process} error for zombie processes.
}
\section{macOS issues}{


\code{ps_environ()} usually does not work on macOS nowadays. This is because
macOS does not allow reading the environment variables of another
process. Accoding to the Darwin source code, \code{ps_environ} will work is
one of these conditions hold:
\itemize{
\item You are running a development or debug kernel, i.e. if you are
debugging the macOS kernel itself.
\item The target process is same as the calling process.
\item SIP if off.
\item The target process is not restricted, e.g. it is running a binary
that was not signed.
\item The calling process has the
\code{com.apple.private.read-environment-variables} entitlement. However
adding this entitlement to the R binary makes R crash on startup.
}

Otherwise \code{ps_environ} will return an empty set of environment variables
on macOS.

Issue 121 might have more information about this.
}

\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
p <- ps_handle()
p
env <- ps_environ(p)
env[["R_HOME"]]
\dontshow{\}) # examplesIf}
}
\seealso{
Other process handle functions: 
\code{\link{ps_children}()},
\code{\link{ps_cmdline}()},
\code{\link{ps_connections}()},
\code{\link{ps_cpu_times}()},
\code{\link{ps_create_time}()},
\code{\link{ps_cwd}()},
\code{\link{ps_descent}()},
\code{\link{ps_exe}()},
\code{\link{ps_handle}()},
\code{\link{ps_interrupt}()},
\code{\link{ps_is_running}()},
\code{\link{ps_kill}()},
\code{\link{ps_memory_info}()},
\code{\link{ps_name}()},
\code{\link{ps_num_fds}()},
\code{\link{ps_num_threads}()},
\code{\link{ps_open_files}()},
\code{\link{ps_pid}()},
\code{\link{ps_ppid}()},
\code{\link{ps_resume}()},
\code{\link{ps_send_signal}()},
\code{\link{ps_shared_libs}()},
\code{\link{ps_status}()},
\code{\link{ps_suspend}()},
\code{\link{ps_terminal}()},
\code{\link{ps_terminate}()},
\code{\link{ps_uids}()},
\code{\link{ps_username}()}
}
\concept{process handle functions}
