% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_suspend}
\alias{ps_suspend}
\title{Suspend (stop) the process}
\usage{
ps_suspend(p = ps_handle())
}
\arguments{
\item{p}{Process handle.}
}
\description{
Suspend process execution with \code{SIGSTOP} preemptively checking
whether PID has been reused. On Windows this has the effect of
suspending all process threads.
}
\examples{
\dontshow{if (ps::ps_is_supported() && ps::ps_os_type()["POSIX"] && ! ps:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
px <- processx::process$new("sleep", "10")
p <- ps_handle(px$get_pid())
p
ps_suspend(p)
ps_status(p)
ps_resume(p)
ps_status(p)
ps_kill(p)
\dontshow{\}) # examplesIf}
}
\seealso{
Other process handle functions: 
\code{\link{ps_children}()},
\code{\link{ps_cmdline}()},
\code{\link{ps_connections}()},
\code{\link{ps_cpu_times}()},
\code{\link{ps_create_time}()},
\code{\link{ps_cwd}()},
\code{\link{ps_descent}()},
\code{\link{ps_environ}()},
\code{\link{ps_exe}()},
\code{\link{ps_handle}()},
\code{\link{ps_interrupt}()},
\code{\link{ps_is_running}()},
\code{\link{ps_kill}()},
\code{\link{ps_memory_info}()},
\code{\link{ps_name}()},
\code{\link{ps_num_fds}()},
\code{\link{ps_num_threads}()},
\code{\link{ps_open_files}()},
\code{\link{ps_pid}()},
\code{\link{ps_ppid}()},
\code{\link{ps_resume}()},
\code{\link{ps_send_signal}()},
\code{\link{ps_shared_libs}()},
\code{\link{ps_status}()},
\code{\link{ps_terminal}()},
\code{\link{ps_terminate}()},
\code{\link{ps_uids}()},
\code{\link{ps_username}()}
}
\concept{process handle functions}
