% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.R
\name{ess_basic}
\alias{ess_basic}
\alias{ess_basic.default}
\alias{ess_basic.rvar}
\title{Basic version of the effective sample size}
\usage{
ess_basic(x, ...)

\method{ess_basic}{default}(x, split = TRUE, ...)

\method{ess_basic}{rvar}(x, split = TRUE, ...)
}
\arguments{
\item{x}{(multiple options) One of:
\itemize{
\item A matrix of draws for a single variable (iterations x chains). See
\code{\link[=extract_variable_matrix]{extract_variable_matrix()}}.
\item An \code{\link{rvar}}.
}}

\item{...}{Arguments passed to individual methods (if applicable).}

\item{split}{(logical) Should the estimate be computed on split chains? The
default is \code{TRUE}.}
}
\value{
If the input is an array, returns a single numeric value. If any of the draws
is non-finite, that is, \code{NA}, \code{NaN}, \code{Inf}, or \code{-Inf}, the returned output
will be (numeric) \code{NA}. Also, if all draws within any of the chains of a
variable are the same (constant), the returned output will be (numeric) \code{NA}
as well. The reason for the latter is that, for constant draws, we cannot
distinguish between variables that are supposed to be constant (e.g., a
diagonal element of a correlation matrix is always 1) or variables that just
happened to be constant because of a failure of convergence or other problems
in the sampling process.

If the input is an \code{\link{rvar}}, returns an array of the same dimensions as the
\code{\link{rvar}}, where each element is equal to the value that would be returned by
passing the draws array for that element of the \code{\link{rvar}} to this function.
}
\description{
Compute the basic effective sample size (ESS) estimate for a single variable
as described in Gelman et al. (2013) with some changes according to Vehtari et
al. (2021). For practical applications, we strongly
recommend the improved ESS convergence diagnostics implemented in
\code{\link[=ess_bulk]{ess_bulk()}} and \code{\link[=ess_tail]{ess_tail()}}. See Vehtari (2021) for an in-depth
comparison of different effective sample size estimators.
}
\examples{
mu <- extract_variable_matrix(example_draws(), "mu")
ess_basic(mu)

d <- as_draws_rvars(example_draws("multi_normal"))
ess_basic(d$Sigma)

}
\references{
Andrew Gelman, John B. Carlin, Hal S. Stern, David B. Dunson, Aki Vehtari and
Donald B. Rubin (2013). \emph{Bayesian Data Analysis, Third Edition}. Chapman and
Hall/CRC.

Aki Vehtari, Andrew Gelman, Daniel Simpson, Bob Carpenter, and
Paul-Christian Bürkner (2021). Rank-normalization, folding, and
localization: An improved R-hat for assessing convergence of
MCMC (with discussion). \emph{Bayesian Data Analysis}. 16(2), 667-–718.
doi:10.1214/20-BA1221

Aki Vehtari (2021). Comparison of MCMC effective sample size estimators.
Retrieved from https://avehtari.github.io/rhat_ess/ess_comparison.html
}
\seealso{
Other diagnostics: 
\code{\link{ess_bulk}()},
\code{\link{ess_quantile}()},
\code{\link{ess_sd}()},
\code{\link{ess_tail}()},
\code{\link{mcse_mean}()},
\code{\link{mcse_quantile}()},
\code{\link{mcse_sd}()},
\code{\link{rhat_basic}()},
\code{\link{rhat}()},
\code{\link{rstar}()}
}
\concept{diagnostics}
