% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_ply.r
\name{a_ply}
\alias{a_ply}
\title{Split array, apply function, and discard results.}
\usage{
a_ply(.data, .margins, .fun = NULL, ..., .expand = TRUE,
  .progress = "none", .inform = FALSE, .print = FALSE,
  .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{.data}{matrix, array or data frame to be processed}

\item{.margins}{a vector giving the subscripts to split up \code{data} by.
1 splits up by rows, 2 by columns and c(1,2) by rows and columns, and so
on for higher dimensions}

\item{.fun}{function to apply to each piece}

\item{...}{other arguments passed on to \code{.fun}}

\item{.expand}{if \code{.data} is a data frame, should output be 1d (expand
 = FALSE), with an element for each row; or nd (expand = TRUE), with a
dimension for each variable.}

\item{.progress}{name of the progress bar to use, see
\code{\link{create_progress_bar}}}

\item{.inform}{produce informative error messages?  This is turned off
by default because it substantially slows processing speed, but is very
useful for debugging}

\item{.print}{automatically print each result? (default: \code{FALSE})}

\item{.parallel}{if \code{TRUE}, apply function in parallel, using parallel
backend provided by foreach}

\item{.paropts}{a list of additional options passed into
the \code{\link[foreach]{foreach}} function when parallel computation
is enabled.  This is important if (for example) your code relies on
external data or packages: use the \code{.export} and \code{.packages}
arguments to supply them so that all cluster nodes have the correct
environment set up for computing.}
}
\value{
Nothing
}
\description{
For each slice of an array, apply function and discard results
}
\section{Input}{
 This function splits matrices, arrays and data frames by
  dimensions
}

\section{Output}{

  All output is discarded. This is useful for functions that you are
  calling purely for their side effects like displaying plots or
  saving output.
}
\references{
Hadley Wickham (2011). The Split-Apply-Combine Strategy
  for Data Analysis. Journal of Statistical Software, 40(1), 1-29.
  \url{http://www.jstatsoft.org/v40/i01/}.
}
\seealso{
Other array input: \code{\link{aaply}},
  \code{\link{adply}}, \code{\link{alply}}

Other no output: \code{\link{d_ply}}, \code{\link{l_ply}},
  \code{\link{m_ply}}
}
\keyword{manip}

