% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plm-package.R
\docType{package}
\name{plm-package}
\alias{plm-package}
\title{plm package: linear models for panel data}
\description{
plm is a package for R which intends to make the estimation of linear panel
models straightforward. plm provides functions to estimate a wide variety of
models and to make (robust) inference.
}
\details{
For a gentle and comprehensive introduction to the package, please see the
package's vignette.

The main functions to estimate models are:
\itemize{
\item \code{plm}: panel data estimators using \code{lm} on transformed data,
\item \code{pvcm}: variable coefficients models
\item \code{pgmm}: generalized method of moments (GMM) estimation for panel
data,
\item \code{pggls}: estimation of general feasible generalized least squares models,
\item \code{pmg}: mean groups (MG), demeaned MG and common correlated effects
(CCEMG) estimators,
\item \code{pcce}: estimators for common correlated effects mean groups (CCEMG) and
pooled (CCEP) for panel data with common factors,
\item \code{pldv}: panel estimators for limited dependent variables.
}

Next to the model estimation functions, the package offers several
functions for statistical tests related to panel data/models.

Multiple functions for (robust) variance--covariance matrices are
at hand as well.

The package also provides data sets to demonstrate functions and to
replicate some text book/paper results.  Use
\code{data(package="plm")} to view a list of available data sets in
the package.
}
\examples{

data("Produc", package = "plm")
zz <- plm(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp,
          data = Produc, index = c("state","year"))
summary(zz)

# replicates some results from Baltagi (2013), table 3.1
data("Grunfeld", package = "plm")
p <- plm(inv ~ value + capital,
         data = Grunfeld, model="pooling")

wi <- plm(inv ~ value + capital,
          data = Grunfeld, model="within", effect = "twoways")

swar <- plm(inv ~ value + capital,
            data = Grunfeld, model="random", effect = "twoways")
          
amemiya <- plm(inv ~ value + capital,
               data = Grunfeld, model = "random", random.method = "amemiya",
               effect = "twoways")
                
walhus <- plm(inv ~ value + capital,
              data = Grunfeld, model = "random", random.method = "walhus",
              effect = "twoways")

}
\keyword{package}
