% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxSE.R
\name{mxSE}
\alias{mxSE}
\title{Compute standard errors in OpenMx}
\usage{
mxSE(x, model, details = FALSE, cov, forceName = FALSE,
  silent = FALSE, ..., defvar.row = as.integer(NA), data = "data")
}
\arguments{
\item{x}{the parameter to get SEs on (reference or expression)}

\item{model}{the \code{\link{mxModel}} to use.}

\item{details}{logical. Whether to provide further details, e.g. the full
sampling covariance matrix of x.}

\item{cov}{optional matrix of covariances among the free parameters. If 
missing, the inverse Hessian from the fitted model is used.}

\item{forceName}{logical; defaults to \code{FALSE}.  Set to \code{TRUE}
if \code{x} is an R symbol that refers to a character string.}

\item{silent}{logical; defaults to \code{FALSE}.  If \code{TRUE},
message-printing is suppressed.}

\item{...}{further named arguments passed to \code{\link{mxEval}}}

\item{defvar.row}{which row to load for any definition variables}

\item{data}{name of data from which to load definition variables}
}
\value{
SE value(s) returned as a matrix when \code{details} is FALSE.
When \code{details} is TRUE, a list of the SE value(s) and the full 
sampling covariance matrix.
}
\description{
This function allows you to obtain standard errors for arbitrary
expressions, named entities, and algebras.
}
\details{
x can be the name of an algebra, a bracket address, named entity
or arbitrary expression.
When the \code{details} argument is TRUE, the full
sampling covariance matrix of \code{x} is also returned as part of a list.
The square root of the diagonals of this sampling covariance matrix are
the standard errors.

When supplying the \code{cov} argument, take care that the free parameter
covariance matrix is given, not the information matrix.  These 
two are inverses of one another.

This function uses the delta method to compute the standard error of arbitrary
and possibly nonlinear functions of the free parameters.  The delta method
makes a first-order Taylor approximation of the nonlinear function.  The
nonlinear function is a map from all the free parameters to some transformed
subset of parameters: the linearization of this map is given by the Jacobian
\eqn{J}.  In equation form, the delta method computes standard errors by the following:

\deqn{J^T C J}

where \eqn{J} is the Jacobian of the nonlinear parameter transformation
and \eqn{C} is the covariance matrix of the free parameters (e.g., two
times the inverse of the Hessian of the minus two log likelihood function).
}
\examples{
library(OpenMx)
data(demoOneFactor)
# ===============================
# = Make and run a 1-factor CFA =
# ===============================

latents  = c("G") # the latent factor
manifests = names(demoOneFactor) # manifest variables to be modeled
# ===========================
# = Make and run the model! =
# ===========================
m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests, labels=paste0('lambda', 1:5)),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = mxRun(m1)
mxSE(lambda5, model = m1)
mxSE(lambda1^2, model = m1)
}
\references{
- \url{https://en.wikipedia.org/wiki/Standard_error}
}
\seealso{
- \code{\link{mxCI}}
}
