% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npsurv-package.R
\docType{data}
\name{acfail}
\alias{acfail}
\title{Air Conditioner Failure Data}
\format{
A numeric vector storing the failure times.
}
\source{
Proschan (1963)
}
\description{
Contains the number of operating hours between successive failure times of
the air conditioning systems in Boeing airplanes
}
\examples{

data(acfail)
r = Uhaz(acfail, deg=2)
plot(r$h, fn="h")
plot(r$h, fn="d")

}
\references{
Proschan, F. (1963). Theoretical explanation of observed
decreasing failure rate. \emph{Technometrics}, \bold{5}, 375-383.
}
\seealso{
\code{\link{Uhaz}}.
}
\keyword{datasets}
