% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns_altid.R
\name{ns_altid}
\alias{ns_altid}
\title{Get taxon by uid, id, or elCode}
\usage{
ns_altid(uid = NULL, id = NULL, el_code = NULL, ...)
}
\arguments{
\item{uid}{(character) A NatureServe taxon id (The taxon’s Element Global
UID)}

\item{id}{The primary key value (ELEMENT_GLOBAL_ID) of the record within
Central Biotics}

\item{el_code}{The Biotics Element Code (ELCODE_BCD) of the record}

\item{...}{Curl options passed on to \code{\link[crul]{verb-GET}}}
}
\value{
A list with lots of elements
}
\description{
Get taxon by uid, id, or elCode
}
\details{
see https://explorer.natureserve.org/api-docs/#_taxon_data_model
for details on the response data
}
\examples{
\dontrun{
ns_altid(uid = "ELEMENT_GLOBAL.2.154701")
ns_altid(id = "154701")
ns_altid(el_code = "PDRAN0F010")
}
}
\references{
https://explorer.natureserve.org/api-docs/
}
