% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMetrics.R
\name{mauc}
\alias{mauc}
\title{Multiclass Area Under the Curve}
\usage{
mauc(actual, predicted)
}
\arguments{
\item{actual}{A vector of the labels. Can be \code{numeric, character, or factor}}

\item{predicted}{A data.frame of predicted values. Can be \code{matrix, data.frame}}
}
\description{
Calculates the area under the curve for a binary classifcation model
}
\examples{
setosa <- glm(I(Species == 'setosa') ~ Sepal.Length, data = iris, family = 'binomial')
versicolor <- glm(I(Species == 'versicolor') ~ Sepal.Length, data = iris, family = 'binomial')
virginica <- glm(I(Species == 'virginica') ~ Sepal.Length, data = iris, family = 'binomial')

Pred <-
  data.frame(
    setosa = predict(setosa, type = 'response')
    ,versicolor = predict(versicolor, type = 'response')
    ,virginica = predict(virginica, type = 'response')
  )

Predicted = Pred/rowSums(Pred)
Actual = iris$Species

mauc(Actual, Predicted)

}

