% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.Data.Curve.R
\name{plot_RLum.Data.Curve}
\alias{plot_RLum.Data.Curve}
\title{Plot function for an RLum.Data.Curve S4 class object}
\usage{
plot_RLum.Data.Curve(object, par.local = TRUE, norm = FALSE,
  smooth = FALSE, ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum.Data.Curve}} (\bold{required}): S4
object of class \code{RLum.Data.Curve}}

\item{par.local}{\code{\link{logical}} (with default): use local graphical
parameters for plotting, e.g. the plot is shown in one column and one row.
If \code{par.local = FALSE}, global parameters are inherited.}

\item{norm}{\code{\link{logical}} (with default): allows curve normalisation
to the highest count value}

\item{smooth}{\code{\link{logical}} (with default): provides an automatic curve smoothing
based on \code{\link[zoo]{rollmean}}}

\item{\dots}{further arguments and graphical parameters that will be passed
to the \code{plot} function}
}
\value{
Returns a plot.
}
\description{
The function provides a standardised plot output for curve data of an
RLum.Data.Curve S4 class object
}
\details{
Only single curve data can be plotted with this function.  Arguments
according to \code{\link{plot}}.
}
\note{
Not all arguments of \code{\link{plot}} will be passed!
}
\section{Function version}{
 0.2.3 (2017-06-29 18:40:14)
}

\examples{


##plot curve data

#load Example data
data(ExampleData.CW_OSL_Curve, envir = environment())

#transform data.frame to RLum.Data.Curve object
temp <- as(ExampleData.CW_OSL_Curve, "RLum.Data.Curve")

#plot RLum.Data.Curve object
plot_RLum.Data.Curve(temp)


} 

\section{How to cite}{
Kreutzer, S. (2017). plot_RLum.Data.Curve(): Plot function for an RLum.Data.Curve S4 class object. Function version 0.2.3. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.5. https://CRAN.R-project.org/package=Luminescence
}

\references{
#
}
\seealso{
\code{\link{plot}}, \code{\link{plot_RLum}}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\keyword{aplot}
