% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean}
\alias{clean}
\alias{clean.lvm}
\title{Simplify a lvm object}
\usage{
clean(x, ...)

\method{clean}{lvm}(x, rm.exo = TRUE, rm.endo = TRUE,
  rm.latent = TRUE, ...)
}
\arguments{
\item{x}{\code{lvm}-object}

\item{...}{additional arguments to lower level functions}

\item{rm.exo}{should exogenous variables with no links be removed from the object?}

\item{rm.endo}{should endogenous variables with no links be removed from the object?}

\item{rm.latent}{should latent variables with no links be removed from the object?}
}
\description{
Remove variables with no link.
}
\examples{

m <- lvm()
m <- regression(m, x=paste0("x",1:5),y="y1")
m <- regression(m, x=paste0("x",1:5),y="y2")
covariance(m) <- y1~y2

cancel(m) <- y1 ~ x1
cancel(m) <- y2 ~ x1
clean(m)

m <- lvm(y1 ~ eta + x1, y2 ~ eta, y3 ~ eta + x2)
latent(m) <- ~eta
clean(m)
m
cancel(m) <- y1 ~ eta
cancel(m) <- y2 ~ eta
cancel(m) <- y3 ~ eta
clean(m)
}
