% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ablation.R
\name{plotAblation}
\alias{plotAblation}
\title{Create plot from an ablation log}
\usage{
plotAblation(
  ablog,
  pdf.file = NULL,
  pdf.width = 20,
  type = c("mean", "boxplot"),
  mar = par("mar"),
  ylab = "Mean configuration cost",
  ylim = NULL,
  ...
)
}
\arguments{
\item{ablog}{(\code{list()}|\code{character(1)}) Ablation log object returned by \code{\link[=ablation]{ablation()}}. Alternatively, the path to an \code{.Rdata} file, e.g., \code{"log-ablation.Rdata"}, from which the object will be loaded.}

\item{pdf.file}{Output filename.}

\item{pdf.width}{Width provided to create the pdf file.}

\item{type}{Type of plot. Supported values are \code{"mean"} and \code{"boxplot"}.}

\item{mar}{Vector with the margins for the ablation plot.}

\item{ylab}{Label of y-axis.}

\item{ylim}{Numeric vector of length 2, giving the y coordinates ranges.}

\item{...}{Further graphical parameters may also be supplied as
arguments. See \code{\link[graphics:plot.default]{graphics::plot.default()}}.}
}
\description{
Create plot from an ablation log
}
\examples{
logfile <- file.path(system.file(package="irace"), "exdata", "log-ablation.Rdata")
plotAblation(ablog = logfile)
}
\seealso{
\code{\link[=ablation]{ablation()}}
}
\author{
Leslie Pérez Cáceres and Manuel López-Ibáñez
}
