% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{checkIraceScenario}
\alias{checkIraceScenario}
\title{Test that the given irace scenario can be run.}
\usage{
checkIraceScenario(scenario, parameters = NULL)
}
\arguments{
\item{scenario}{Data structure containing \pkg{irace} settings.The data structure
has to be the one returned by the function \code{\link{defaultScenario}} and
\code{\link{readScenario}}.}

\item{parameters}{Data structure containing the parameter definition. The data
structure has to be the one returned by the function \code{\link{readParameters}}.
See documentation of this function for details.}
}
\value{
returns \code{TRUE} if succesful and gives an error and returns
\code{FALSE} otherwise.
}
\description{
\code{checkIraceScenario} tests that the given irace scenario
  can be run by checking the scenario settings provided and trying to run
  the target-algorithm.
}
\details{
Provide the \code{parameters} argument only if the parameter list
  should not be obtained from the parameter file given by the scenario. If
  the parameter list is provided it will not be checked. This function will
  try to execute the target-algorithm.
}
\seealso{
\describe{
 \item{\code{\link{readScenario}}}{for reading a configuration scenario from a file.}
 \item{\code{\link{printScenario}}}{prints the given scenario.}
 \item{\code{\link{defaultScenario}}}{returns the default scenario settings of \pkg{irace}.}
 \item{\code{\link{checkScenario}}}{to check that the scenario is valid.}
}
}
\author{
Manuel López-Ibáñez and Jérémie Dubois-Lacoste
}
