% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parameters_bayesian.R
\name{get_parameters.BGGM}
\alias{get_parameters.BGGM}
\alias{get_parameters.MCMCglmm}
\alias{get_parameters.BFBayesFactor}
\alias{get_parameters.stanmvreg}
\alias{get_parameters.brmsfit}
\alias{get_parameters.stanreg}
\alias{get_parameters.bayesx}
\alias{get_parameters.bamlss}
\alias{get_parameters.sim.merMod}
\alias{get_parameters.sim}
\title{Get model parameters from Bayesian models}
\usage{
\method{get_parameters}{BGGM}(
  x,
  component = c("correlation", "conditional", "intercept", "all"),
  summary = FALSE,
  centrality = "mean",
  ...
)

\method{get_parameters}{MCMCglmm}(
  x,
  effects = c("fixed", "random", "all"),
  summary = FALSE,
  centrality = "mean",
  ...
)

\method{get_parameters}{BFBayesFactor}(
  x,
  effects = c("all", "fixed", "random"),
  component = c("all", "extra"),
  iterations = 4000,
  progress = FALSE,
  verbose = TRUE,
  summary = FALSE,
  centrality = "mean",
  ...
)

\method{get_parameters}{stanmvreg}(
  x,
  effects = c("fixed", "random", "all"),
  parameters = NULL,
  summary = FALSE,
  centrality = "mean",
  ...
)

\method{get_parameters}{brmsfit}(
  x,
  effects = "fixed",
  component = "all",
  parameters = NULL,
  summary = FALSE,
  centrality = "mean",
  ...
)

\method{get_parameters}{stanreg}(
  x,
  effects = c("fixed", "random", "all"),
  component = c("location", "all", "conditional", "smooth_terms", "sigma",
    "distributional", "auxiliary"),
  parameters = NULL,
  summary = FALSE,
  centrality = "mean",
  ...
)

\method{get_parameters}{bayesx}(
  x,
  component = c("conditional", "smooth_terms", "all"),
  summary = FALSE,
  centrality = "mean",
  ...
)

\method{get_parameters}{bamlss}(
  x,
  component = c("all", "conditional", "smooth_terms", "location", "distributional",
    "auxiliary"),
  parameters = NULL,
  summary = FALSE,
  centrality = "mean",
  ...
)

\method{get_parameters}{sim.merMod}(
  x,
  effects = c("fixed", "random", "all"),
  parameters = NULL,
  summary = FALSE,
  centrality = "mean",
  ...
)

\method{get_parameters}{sim}(x, parameters = NULL, summary = FALSE, centrality = "mean", ...)
}
\arguments{
\item{x}{A fitted model.}

\item{component}{Should all predictor variables, predictor variables for the
conditional model, the zero-inflated part of the model, the dispersion
term or the instrumental variables be returned? Applies to models
with zero-inflated and/or dispersion formula, or to models with instrumental
variable (so called fixed-effects regressions). May be abbreviated. Note that the
\emph{conditional} component is also called \emph{count} or \emph{mean}
component, depending on the model.}

\item{summary}{Logical, indicates whether the full posterior samples
(\code{summary = FALSE})) or the summarized centrality indices of
the posterior samples (\code{summary = TRUE})) should be returned as
estimates.}

\item{centrality}{Only for models with posterior samples, and when
\code{summary = TRUE}. In this case, \code{centrality = "mean"} would
calculate means of posterior samples for each parameter, while
\code{centrality = "median"} would use the more robust median value as
measure of central tendency.}

\item{...}{Currently not used.}

\item{effects}{Should parameters for fixed effects, random effects
or both be returned? Only applies to mixed models. May be abbreviated.}

\item{iterations}{Number of posterior draws.}

\item{progress}{Display progress.}

\item{verbose}{Toggle messages and warnings.}

\item{parameters}{Regular expression pattern that describes the parameters that
should be returned.}
}
\value{
The posterior samples from the requested parameters as data frame.
If \code{summary = TRUE}, returns a data frame with two columns: the
parameter names and the related point estimates (based on \code{centrality}).
}
\description{
Returns the coefficients (or posterior samples for Bayesian
models) from a model.
}
\details{
In most cases when models either return different "effects" (fixed,
random) or "components" (conditional, zero-inflated, ...), the arguments
\code{effects} and \code{component} can be used.
}
\section{BFBayesFactor Models}{

Note that for \code{BFBayesFactor} models (from the \strong{BayesFactor} package),
posteriors are only extracted from the first numerator model (i.e.,
\code{model[1]}). If you want to apply some function \code{foo()} to another
model stored in the \code{BFBayesFactor} object, index it directly, e.g.
\code{foo(model[2])}, \code{foo(1/model[5])}, etc.
See also \code{\link[bayestestR:weighted_posteriors]{bayestestR::weighted_posteriors()}}.
}

\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_parameters(m)
}
