% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huge.inference.R
\name{huge.inference}
\alias{huge.inference}
\title{Graph inference}
\usage{
huge.inference(data, T, adj, alpha = 0.05, type = "Gaussian",
  method = "score")
}
\arguments{
\item{data}{The input \code{n} by \code{d} data matrix(\code{n} is the sample size and \code{d} is the dimension).}

\item{T}{The estimated inverse of correlation matrix of the data.}

\item{adj}{The adjacency matrix corresponding to the graph.}

\item{alpha}{The significance level of hypothesis.The default value is \code{0.05}.}

\item{type}{The type of input data. There are 2 options: \code{"Gaussian"} and \code{"Nonparanormal"}. The default value is \code{"Gaussian"}.}

\item{method}{When using nonparanormal graphical model. Test method with 2 options: \code{"score"} and \code{"wald"}. The default value is \code{"score"}.}
}
\value{
An object is returned:
\item{data}{
  The \code{n} by \code{d} data matrix from the input.
}
\item{p}{
  The \code{d} by \code{d} p-value matrix of hypothesis.
}
\item{error}{
  The type I error of hypothesis at alpha significance level.
}
}
\description{
Implements the inference for high dimensional graphical models, including Gaussian and Nonparanormal graphical models
We consider the problems of testing the presence of a single edge and the hypothesis is that the edge is absent.
}
\details{
For Nonparanormal graphical model we provide Score test method and Wald Test. However it is really slow for inferencing on Nonparanormal model, especially for large data.
}
\examples{
#generate data
L = huge.generator(n = 50, d = 12, graph = "hub", g = 4)

#graph path estimation using glasso
est = huge(L$data, method = "glasso")

#inference of Gaussian graphical model at 0.05 significance level
T = tail(est$icov, 1)[[1]]
out1 = huge.inference(L$data, T, L$theta)

#inference of Nonparanormal graphical model using score test at 0.05 significance level
T = tail(est$icov, 1)[[1]]
out2 = huge.inference(L$data, T, L$theta, type = "Nonparanormal")

#inference of Nonparanormal graphical model using wald test at 0.05 significance level
T = tail(est$icov, 1)[[1]]
out3 = huge.inference(L$data, T, L$theta, type = "Nonparanormal", method = "wald")

#inference of Nonparanormal graphical model using wald test at 0.1 significance level
T = tail(est$icov, 1)[[1]]
out4 = huge.inference(L$data, T, L$theta, 0.1, type = "Nonparanormal", method = "wald")
}
\references{
1.Q Gu, Y Cao, Y Ning, H Liu. Local and global inference for high dimensional nonparanormal graphical models.\cr
2.J Jankova, S Van De Geer. Confidence intervals for high-dimensional inverse covariance estimation. \emph{Electronic Journal of Statistics}, 2015.\cr
}
\seealso{
\code{\link{huge}}, and \code{\link{huge-package}}.
}
