% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC-support.R
\name{hpd.summary}
\alias{hpd.summary}
\title{Summarize an emmGrid from a Bayesian model}
\usage{
hpd.summary(object, prob, by, type, point.est = median, delta,
  bias.adjust = get_emm_option("back.bias.adj"), sigma, ...)
}
\arguments{
\item{object}{an \code{emmGrid} object having a non-missing \code{post.beta} slot}

\item{prob}{numeric probability content for HPD intervals (note: when not specified,
the current \code{level} option is used; see \code{\link{emm_options}})}

\item{by}{factors to use as \code{by} variables}

\item{type}{prediction type as in \code{\link{summary.emmGrid}}}

\item{point.est}{function to use to compute the point estimates from the 
posterior sample for each grid point}

\item{delta}{Numeric equivalence threshold (on the linear predictor scale 
regardless of \code{type}).
See the section below on equivalence testing.}

\item{bias.adjust}{Logical value for whether to adjust for bias in
back-transforming (\code{type = "response"}). This requires a value of 
\code{sigma} to exist in the object or be specified.}

\item{sigma}{Error SD assumed for bias correction (when 
\code{type = "response"}. If not specified,
\code{object@misc$sigma} is used, and a warning if it is not found or invalid.
\emph{Note:} \code{sigma} may be a vector, as long as it conforms to the 
number of observations in the posterior sample.}

\item{...}{required but not used}
}
\value{
an object of class \code{summary_emm}
}
\description{
This function computes point estimates and HPD intervals for each
factor combination in \code{object@emmGrid}. While this function
may be called independently, it is called automatically by the S3 method
\code{\link{summary.emmGrid}} when the object is based on a Bayesian model.
(Note: the \code{level} argument, or its default, is passed as \code{prob}).
}
\section{Equivalence testing note}{

  If \code{delta} is positive, two columns labeled \code{p.equiv} and
  \code{odds.eq} are appended to the summary. \code{p.equiv} is the fraction
  of posterior estimates having absolute values less than \code{delta}. The
  \code{odds.eq} column is just \code{p.equiv} converted to an odds ratio; so
  it is the posterior odds of equivalence.
  
  A high value of \code{p.equiv} is evidence
  in favor of equivalence. It can be used to obtain something equivalent
  (in spirit) to the frequentist Schuirmann (TOST) procedure, whereby we would
  conclude equivalence at significance level \eqn{\alpha} if the \eqn{(1 - 2\alpha)}
  confidence interval falls entirely in the interval \eqn{[-\delta, \delta]}.
  Similarly in the Bayesian context, an equally strong argument for
  equivalence is obtained if \code{p.equiv} exceeds \eqn{1 - 2\alpha}.
  
  A closely related quantity is the ROPE (region of practical equivalence),
  obtainable via \code{bayestestR::rope(object, range = c(-delta, delta))}.
  Its value is approximately \code{100 * p.equiv / 0.95} if the default
  \code{ci = 0.95} is used. See also \pkg{bayestestR}'s 
  \href{https://github.com/easystats/bayestestR/issues/567}{issue #567}.
  
  Finally, a Bayes factor for equivalence is obtainable by dividing 
  \code{odds.eq} by the prior odds of equivalence, assessed or elicited separately.
}

\examples{
if(require("coda")) 
    emm_example("hpd.summary-coda")
    # Use emm_example("hpd.summary-coda", list = TRUE) # to see just the code

}
\seealso{
summary.emmGrid
}
