% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cld-emm.R
\name{cld.emmGrid}
\alias{cld.emmGrid}
\alias{cld.emm_list}
\title{Compact letter displays}
\usage{
\method{cld}{emmGrid}(object, details = FALSE, sort = TRUE, by,
  alpha = 0.05, Letters = c("1234567890", LETTERS, letters),
  reversed = decreasing, decreasing = FALSE, signif.sets = FALSE,
  delta = 0, ...)

\method{cld}{emm_list}(object, ..., which = 1)
}
\arguments{
\item{object}{An object of class \code{emmGrid}}

\item{details}{Logical value determining whether detailed information on tests of
pairwise comparisons is displayed}

\item{sort}{Logical value determining whether the EMMs are sorted before the comparisons
are produced. When \code{TRUE}, the results are displayed according to
\code{reversed}.}

\item{by}{Character value giving the name or names of variables by which separate
families of comparisons are tested. If NULL, all means are compared.
If missing, the object's \code{by.vars} setting, if any, is used.}

\item{alpha}{Numeric value giving the significance level for the comparisons}

\item{Letters}{Character vector of letters to use in the display. Any strings of
length greater than 1 are expanded into individual characters}

\item{reversed, decreasing}{Logical value (passed to \code{multcompView::multcompLetters}.)
If \code{TRUE}, the order of use of the letters is reversed.
Either \code{reversed} or \code{decreasing} may be specified, thus providing
compatibility with both \code{multcompView::multcompLetters(..., reversed, ...)} and
\code{multcomp::cld(..., decreasing, ...)}.
In addition, if both \code{sort} and \code{reversed} are TRUE, the sort
order of results is reversed.}

\item{signif.sets}{Logical value. If \code{FALSE} (and \code{delta = 0}), a 
\sQuote{traditional}
compact-letter display is constructed with groupings representing sets of
estimates that are not statistically different. If \code{TRUE}, the criteria
are reversed so that two estimates sharing the same symbol test as significantly
different. See also \code{delta}.}

\item{delta}{Numeric value passed to \code{\link{test.emmGrid}}. If this
is positive, it is used as an equivalence threshold in the TOST procedure for
two-sided equivalence testing. In the resulting compact letter display,
two estimates share the same grouping letter only if they are found to be
statistically equivalent -- that is, groupings reflect actual \emph{findings}
of equivalence rather than failure to find a significant difference.
When \code{delta} is nonzero, \code{signif.sets} is ignored.}

\item{...}{Arguments passed to \code{\link{contrast}} (for example,
an \code{adjust} method)}

\item{which}{Which element of the \code{emm_list} object to process
(If length exceeds one, only the first one is used)}
}
\value{
A \code{\link[=summary.emmGrid]{summary_emm}} object showing the estimated marginal means
plus an additional column labeled \code{.group} (when \code{signif.sets = FALSE}), 
\code{.signif.set} (when \code{signif.sets = TRUE}), or \code{.equiv.set} 
(when \code{delta > 0}).
}
\description{
A method for \code{multcomp::cld()} is provided for users desiring to produce 
compact-letter displays (CLDs). 
This method uses the Piepho (2004) algorithm (as implemented in the
\pkg{multcompView} package) to generate a compact letter display of all
pairwise comparisons of estimated marginal means. The function obtains (possibly
adjusted) P values for all pairwise comparisons of means, using the
\code{\link{contrast}} function with \code{method = "pairwise"}. When a P
value exceeds \code{alpha}, then the two means have at least one letter in
common.
}
\note{
We warn that the default display encourages a poor
practice in interpreting significance tests. Such CLDs are misleading because they
visually group means with comparisons \emph{P} > \code{alpha} as though they 
are equal, when in fact we have only failed to prove that they differ.
A better alternative if one wants to show groupings is to specify an equivalence
threshold \code{delta}; then groupings will be based on actual findings of
equivalence. Another way to display actual findings is to set
\code{signif.sets = TRUE}, so that estimates in the same group are those 
found to be statistically \emph{different}. Obviously, these different options
require different interpretations of the results; the annotations and the label
given the final column help guide how to assess the results.

As further alternatives, consider \code{\link{pwpp}} (graphical display of \emph{P} 
values) or \code{\link{pwpm}} (matrix display).
}
\examples{
if(requireNamespace("multcomp"))
    emm_example("cld-multcomp")
    # Use emm_example("cld-multcomp", list = TRUE) # to just list the code

}
\references{
Piepho, Hans-Peter (2004) An algorithm for a letter-based 
  representation of all pairwise comparisons, 
  Journal of Computational and Graphical Statistics, 
  13(2), 456-466.
}
