% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_predict.R
\name{loo_R2.brmsfit}
\alias{loo_R2.brmsfit}
\alias{loo_R2}
\title{Compute a LOO-adjusted R-squared for regression models}
\usage{
\method{loo_R2}{brmsfit}(
  object,
  resp = NULL,
  summary = TRUE,
  robust = FALSE,
  probs = c(0.025, 0.975),
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{summary}{Should summary statistics be returned
instead of the raw values? Default is \code{TRUE}.}

\item{robust}{If \code{FALSE} (the default) the mean is used as 
the measure of central tendency and the standard deviation as 
the measure of variability. If \code{TRUE}, the median and the 
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile} 
function. Only used if \code{summary} is \code{TRUE}.}

\item{...}{Further arguments passed to 
\code{\link[brms:posterior_epred.brmsfit]{posterior_epred}} and
\code{\link[brms:log_lik.brmsfit]{log_lik}},
which are used in the computation of the R-squared values.}
}
\value{
If \code{summary = TRUE}, an M x C matrix is returned
 (M = number of response variables and c = \code{length(probs) + 2}) 
 containing summary statistics of the LOO-adjusted R-squared values.
 If \code{summary = FALSE}, the posterior draws of the LOO-adjusted
 R-squared values are returned in an S x M matrix (S is the number of draws).
}
\description{
Compute a LOO-adjusted R-squared for regression models
}
\examples{
\dontrun{
fit <- brm(mpg ~ wt + cyl, data = mtcars)
summary(fit)
loo_R2(fit)

# compute R2 with new data
nd <- data.frame(mpg = c(10, 20, 30), wt = c(4, 3, 2), cyl = c(8, 6, 4))
loo_R2(fit, newdata = nd)
}

}
