% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-class.R
\docType{class}
\name{brmsfit-class}
\alias{brmsfit-class}
\alias{brmsfit}
\title{Class \code{brmsfit} of models fitted with the \pkg{brms} package}
\description{
Models fitted with the \code{\link[brms:brms-package]{brms}} package are 
represented as a \code{brmsfit} object, which contains the posterior 
draws (samples), model formula, Stan code, relevant data, and other information.
}
\details{
See \code{methods(class = "brmsfit")} for an overview of available methods.
}
\section{Slots}{

\describe{
\item{\code{formula}}{A \code{\link{brmsformula}} object.}

\item{\code{data}}{A \code{data.frame} containing all variables used in the model.}

\item{\code{data2}}{A \code{list} of data objects which cannot be passed
via \code{data}.}

\item{\code{prior}}{A \code{\link{brmsprior}} object containing
information on the priors used in the model.}

\item{\code{stanvars}}{A \code{\link{stanvars}} object.}

\item{\code{model}}{The model code in \pkg{Stan} language.}

\item{\code{ranef}}{A \code{data.frame} containing the group-level structure.}

\item{\code{exclude}}{The names of the parameters for which draws are not saved.}

\item{\code{algorithm}}{The name of the algorithm used to fit the model.}

\item{\code{backend}}{The name of the backend used to fit the model.}

\item{\code{threads}}{An object of class `brmsthreads` created by 
\code{\link{threading}}.}

\item{\code{opencl}}{An object of class `brmsopencl` created by \code{\link{opencl}}.}

\item{\code{fit}}{An object of class \code{\link[rstan:stanfit-class]{stanfit}}
among others containing the posterior draws.}

\item{\code{criteria}}{An empty \code{list} for adding model fit criteria
after estimation of the model.}

\item{\code{file}}{Optional name of a file in which the model object was stored in
or loaded from.}

\item{\code{version}}{The versions of \pkg{brms} and \pkg{rstan} with 
which the model was fitted.}

\item{\code{family}}{(Deprecated) A \code{\link{brmsfamily}} object.}

\item{\code{autocor}}{(Deprecated) An \code{\link{cor_brms}} object containing 
the autocorrelation structure if specified.}

\item{\code{cov_ranef}}{(Deprecated) A \code{list} of customized group-level 
covariance matrices.}

\item{\code{stan_funs}}{(Deprecated) A character string of length one or \code{NULL}.}

\item{\code{data.name}}{(Deprecated) The name of \code{data} as specified by the user.}
}}

\seealso{
\code{\link{brms}}, 
  \code{\link{brm}}, 
  \code{\link{brmsformula}}, 
  \code{\link{brmsfamily}}
}
