% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_tax_id.R
\name{bold_tax_id}
\alias{bold_tax_id}
\title{Search BOLD for taxonomy data by BOLD ID.}
\usage{
bold_tax_id(id, dataTypes = "basic", includeTree = FALSE,
  response = FALSE, ...)
}
\arguments{
\item{id}{(integer) One or more BOLD taxonomic identifiers. required.}

\item{dataTypes}{(character) Specifies the datatypes that will be 
returned. 'all' returns all data. 'basic' returns basic taxon information. 
'images' returns specimen images.}

\item{includeTree}{(logical) If TRUE (default: FALSE), returns a list 
containing information for parent taxa as well as the specified taxon.}

\item{response}{(logical) Note that response is the object that returns 
from the Curl call, useful for debugging, and getting detailed info on 
the API call.}

\item{...}{Further args passed on to \code{\link[crul]{HttpClient}}, main 
purpose being curl debugging}
}
\description{
Search BOLD for taxonomy data by BOLD ID.
}
\examples{
\dontrun{
bold_tax_id(id=88899)
bold_tax_id(id=88899, includeTree=TRUE)
bold_tax_id(id=88899, includeTree=TRUE, dataTypes = "stats")
bold_tax_id(id=c(88899,125295))

## dataTypes parameter
bold_tax_id(id=88899, dataTypes = "basic")
bold_tax_id(id=88899, dataTypes = "stats")
bold_tax_id(id=88899, dataTypes = "images")
bold_tax_id(id=88899, dataTypes = "geo")
bold_tax_id(id=88899, dataTypes = "sequencinglabs")
bold_tax_id(id=88899, dataTypes = "depository")
bold_tax_id(id=c(88899,125295), dataTypes = "geo")
bold_tax_id(id=c(88899,125295), dataTypes = "images")

## Passing in NA
bold_tax_id(id = NA)
bold_tax_id(id = c(88899,125295,NA))

## get http response object only
bold_tax_id(id=88899, response=TRUE)
bold_tax_id(id=c(88899,125295), response=TRUE)

## curl debugging
bold_tax_id(id=88899, verbose = TRUE)
}
}
\references{
\url{http://v4.boldsystems.org/index.php/resources/api?type=taxonomy}
}
\seealso{
\code{bold_tax_name}
}
