% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bench-package.R
\docType{package}
\name{bench-package}
\alias{bench}
\alias{bench-package}
\title{bench: High Precision Timing of R Expressions}
\description{
Tools to accurately benchmark and analyze execution times for R expressions.
}
\examples{
dat <- data.frame(x = runif(10000, 1, 1000), y=runif(10000, 1, 1000))

# `bench::mark()` implicitly calls summary() automatically
results <- bench::mark(
  dat[dat$x > 500, ],
  dat[which(dat$x > 500), ],
  subset(dat, x > 500))

# However you can also do so explicitly to filter gc differently.
summary(results, filter_gc = FALSE)

# Or output relative times
summary(results, relative = TRUE)
}
\seealso{
Useful links:
\itemize{
  \item \url{https://bench.r-lib.org/}
  \item \url{https://github.com/r-lib/bench}
  \item Report bugs at \url{https://github.com/r-lib/bench/issues}
}

}
\author{
\strong{Maintainer}: Davis Vaughan \email{davis@rstudio.com}

Authors:
\itemize{
  \item Jim Hester
}

Other contributors:
\itemize{
  \item Drew Schmidt (read_proc_file implementation) [contributor]
}

}
\keyword{internal}
