% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.R
\name{as_bench_time}
\alias{as_bench_time}
\title{Human readable times}
\usage{
as_bench_time(x)
}
\arguments{
\item{x}{A numeric or character vector. Character representations can use
shorthand sizes (see examples).}
}
\description{
Construct, manipulate and display vectors of elapsed times in seconds. These
are numeric vectors, so you can compare them numerically, but they can also
be compared to human readable values such as '10ms'.
}
\examples{
as_bench_time("1ns")
as_bench_time("1")
as_bench_time("1us")
as_bench_time("1ms")
as_bench_time("1s")

as_bench_time("100ns") < "1ms"

sum(as_bench_time(c("1MB", "5MB", "500KB")))
}
